/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.stringFormat;

import java.util.List;
import jetbrains.datalore.base.dateFormat.DateTimeFormat;
import jetbrains.datalore.base.dateFormat.Pattern;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import jetbrains.datalore.base.numberFormat.NumberFormat;
import jetbrains.datalore.base.stringFormat.StringFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001J\u0014\u0010\u000e\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\fJ$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat;", "", "pattern", "", "formatType", "Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "(Ljava/lang/String;Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;)V", "argsNumber", "", "getArgsNumber", "()I", "myFormatters", "", "Lkotlin/Function1;", "format", "value", "values", "initFormatter", "formatPattern", "Companion", "FormatType", "base-portable"})
public final class StringFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final FormatType formatType;
    @NotNull
    private final List<Function1<Object, String>> myFormatters;
    private final int argsNumber;
    @NotNull
    private static final Regex BRACES_REGEX = new Regex("(?![^{]|\\{\\{)(\\{([^{}]*)\\})(?=[^}]|\\}\\}|$)");
    private static final int TEXT_IN_BRACES = 2;

    private StringFormat(String pattern, FormatType formatType) {
        List list;
        this.pattern = pattern;
        this.formatType = formatType;
        switch (WhenMappings.$EnumSwitchMapping$0[this.formatType.ordinal()]) {
            case 1: 
            case 2: {
                list = CollectionsKt.listOf(this.initFormatter(this.pattern, this.formatType));
                break;
            }
            case 3: {
                list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)BRACES_REGEX, (CharSequence)this.pattern, (int)0, (int)2, null), (Function1)1.INSTANCE), (Function1)((Function1)new Function1<String, Function1<? super Object, ? extends String>>(){

                    @NotNull
                    public final Function1<Object, String> invoke(@NotNull String format2) {
                        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
                        FormatType formatType = Companion.detectFormatType(format2);
                        boolean bl = formatType == FormatType.NUMBER_FORMAT || formatType == FormatType.DATETIME_FORMAT;
                        StringFormat stringFormat = this;
                        if (!bl) {
                            boolean bl2 = false;
                            throw new IllegalStateException(("Can't detect type of pattern '" + format2 + "' used in string pattern '" + stringFormat.pattern + '\'').toString());
                        }
                        return this.initFormatter(format2, formatType);
                    }
                })));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.myFormatters = list;
        this.argsNumber = this.myFormatters.size();
    }

    public final int getArgsNumber() {
        return this.argsNumber;
    }

    @NotNull
    public final String format(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.format(CollectionsKt.listOf((Object)value));
    }

    @NotNull
    public final String format(@NotNull List<? extends Object> values2) {
        String string;
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (this.argsNumber != values2.size()) {
            throw new IllegalStateException(("Can't format values " + values2 + " with pattern '" + this.pattern + "'. Wrong number of arguments: expected " + this.argsNumber + " instead of " + values2.size()).toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.formatType.ordinal()]) {
            case 1: 
            case 2: {
                if (!(this.myFormatters.size() == 1)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                string = (String)((Function1)CollectionsKt.single(this.myFormatters)).invoke(CollectionsKt.single(values2));
                break;
            }
            case 3: {
                Ref.IntRef index = new Ref.IntRef();
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)BRACES_REGEX.replace((CharSequence)this.pattern, (Function1)new Function1<MatchResult, CharSequence>(values2, index, this){
                    final /* synthetic */ List<Object> $values;
                    final /* synthetic */ Ref.IntRef $index;
                    final /* synthetic */ StringFormat this$0;
                    {
                        this.$values = $values;
                        this.$index = $index;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull MatchResult it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object originalValue = this.$values.get(this.$index.element);
                        int n = this.$index.element;
                        this.$index.element = n + 1;
                        Function1 formatter = (Function1)StringFormat.access$getMyFormatters$p(this.this$0).get(n);
                        return (CharSequence)formatter.invoke(originalValue);
                    }
                }), (String)"{{", (String)"{", (boolean)false, (int)4, null), (String)"}}", (String)"}", (boolean)false, (int)4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final Function1<Object, String> initFormatter(String formatPattern, FormatType formatType) {
        if (((CharSequence)formatPattern).length() == 0) {
            return initFormatter.1.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[formatType.ordinal()]) {
            case 1: {
                NumberFormat numberFormatter = new NumberFormat(formatPattern);
                return (Function1)new Function1<Object, String>(numberFormatter){
                    final /* synthetic */ NumberFormat $numberFormatter;
                    {
                        this.$numberFormatter = $numberFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        Object object;
                        block3: {
                            block4: {
                                block5: {
                                    Object object2;
                                    block2: {
                                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                        object2 = value;
                                        if (!(object2 instanceof Number)) break block2;
                                        object = this.$numberFormatter.apply((Number)value);
                                        break block3;
                                    }
                                    if (!(object2 instanceof String)) break block4;
                                    object = StringsKt.toFloatOrNull((String)((String)value));
                                    if (object == null) break block5;
                                    Object object3 = object;
                                    NumberFormat numberFormat = this.$numberFormatter;
                                    Number p0 = (Number)object3;
                                    boolean bl = false;
                                    String string = numberFormat.apply(p0);
                                    object = string;
                                    if (string != null) break block3;
                                }
                                object = (String)value;
                                break block3;
                            }
                            throw new IllegalStateException(("Failed to format value with type " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ". Supported types are Number and String.").toString());
                        }
                        return object;
                    }
                };
            }
            case 2: {
                DateTimeFormat dateTimeFormatter = new DateTimeFormat(formatPattern);
                return (Function1)new Function1<Object, String>(dateTimeFormatter){
                    final /* synthetic */ DateTimeFormat $dateTimeFormatter;
                    {
                        this.$dateTimeFormatter = $dateTimeFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        if (!(value instanceof Number)) {
                            boolean bl = false;
                            throw new IllegalStateException(("Value '" + value + "' to be formatted as DateTime expected to be a Number, but was " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName()).toString());
                        }
                        long p0 = ((Number)value).longValue();
                        boolean bl = false;
                        Comparable<Instant> comparable = new Instant(p0);
                        Object object = TimeZone.Companion.getUTC();
                        Instant p02 = comparable;
                        boolean bl2 = false;
                        comparable = ((TimeZone)object).toDateTime(p02);
                        object = this.$dateTimeFormatter;
                        p02 = comparable;
                        boolean bl3 = false;
                        return ((DateTimeFormat)object).apply((DateTime)((Object)p02));
                    }
                };
            }
        }
        throw new IllegalStateException(("Undefined format pattern " + formatPattern).toString());
    }

    public static final /* synthetic */ List access$getMyFormatters$p(StringFormat $this) {
        return $this.myFormatters;
    }

    public /* synthetic */ StringFormat(String pattern, FormatType formatType, DefaultConstructorMarker $constructor_marker) {
        this(pattern, formatType);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "", "(Ljava/lang/String;I)V", "NUMBER_FORMAT", "DATETIME_FORMAT", "STRING_FORMAT", "base-portable"})
    public static final class FormatType
    extends Enum<FormatType> {
        public static final /* enum */ FormatType NUMBER_FORMAT = new FormatType();
        public static final /* enum */ FormatType DATETIME_FORMAT = new FormatType();
        public static final /* enum */ FormatType STRING_FORMAT = new FormatType();
        private static final /* synthetic */ FormatType[] $VALUES;

        public static FormatType[] values() {
            return (FormatType[])$VALUES.clone();
        }

        public static FormatType valueOf(String value) {
            return Enum.valueOf(FormatType.class, value);
        }

        static {
            $VALUES = formatTypeArray = new FormatType[]{FormatType.NUMBER_FORMAT, FormatType.DATETIME_FORMAT, FormatType.STRING_FORMAT};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nJ&\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat$Companion;", "", "()V", "BRACES_REGEX", "Lkotlin/text/Regex;", "TEXT_IN_BRACES", "", "create", "Ljetbrains/datalore/base/stringFormat/StringFormat;", "pattern", "", "type", "Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "formatFor", "expectedArgs", "create$base_portable", "detectFormatType", "forNArgs", "argCount", "forOneArg", "valueInLinePattern", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String valueInLinePattern() {
            return "{}";
        }

        @NotNull
        public final StringFormat forOneArg(@NotNull String pattern, @Nullable FormatType type, @Nullable String formatFor) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return this.create$base_portable(pattern, type, formatFor, 1);
        }

        public static /* synthetic */ StringFormat forOneArg$default(Companion companion, String string, FormatType formatType, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                formatType = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.forOneArg(string, formatType, string2);
        }

        @NotNull
        public final StringFormat forNArgs(@NotNull String pattern, int argCount, @Nullable String formatFor) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return this.create$base_portable(pattern, FormatType.STRING_FORMAT, formatFor, argCount);
        }

        public static /* synthetic */ StringFormat forNArgs$default(Companion companion, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            return companion.forNArgs(string, n, string2);
        }

        private final FormatType detectFormatType(String pattern) {
            return NumberFormat.Companion.isValidPattern(pattern) ? FormatType.NUMBER_FORMAT : (Pattern.Companion.isDateTimeFormat(pattern) ? FormatType.DATETIME_FORMAT : FormatType.STRING_FORMAT);
        }

        @NotNull
        public final StringFormat create$base_portable(@NotNull String pattern, @Nullable FormatType type, @Nullable String formatFor, int expectedArgs) {
            StringFormat stringFormat;
            block4: {
                String string;
                StringFormat it;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                        FormatType formatType = type;
                        if (formatType == null) {
                            formatType = this.detectFormatType(pattern);
                        }
                        FormatType formatType2 = formatType;
                        it = stringFormat = new StringFormat(pattern, formatType2, null);
                        boolean bl = false;
                        if (expectedArgs <= 0 || it.getArgsNumber() == expectedArgs) break block4;
                        boolean bl2 = false;
                        string = formatFor;
                        if (string == null) break block5;
                        String it2 = string;
                        boolean bl3 = false;
                        String string2 = "to format '" + formatFor + '\'';
                        string = string2;
                        if (string2 != null) break block6;
                    }
                    string = "";
                }
                String formatFor2 = string;
                String string3 = "Wrong number of arguments in pattern '" + pattern + "' " + formatFor2 + ". Expected " + expectedArgs + ' ' + (expectedArgs > 1 ? "arguments" : "argument") + " instead of " + it.getArgsNumber();
                throw new IllegalArgumentException(string3.toString());
            }
            return stringFormat;
        }

        public static /* synthetic */ StringFormat create$base_portable$default(Companion companion, String string, FormatType formatType, String string2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                formatType = null;
            }
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                n = -1;
            }
            return companion.create$base_portable(string, formatType, string2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormatType.values().length];
            try {
                nArray[FormatType.NUMBER_FORMAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatType.DATETIME_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatType.STRING_FORMAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

