/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.DodgePos;
import jetbrains.datalore.plot.base.pos.DodgeVPos;
import jetbrains.datalore.plot.base.pos.FillPos;
import jetbrains.datalore.plot.base.pos.JitterDodgePos;
import jetbrains.datalore.plot.base.pos.JitterPos;
import jetbrains.datalore.plot.base.pos.NudgePos;
import jetbrains.datalore.plot.base.pos.StackPos;
import jetbrains.datalore.plot.base.pos.StackingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ%\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ%\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0004J\u001f\u0010\u0014\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0015J9\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0015J%\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/pos/PositionAdjustments;", "", "()V", "dodge", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "groupCount", "", "width", "", "(Ljetbrains/datalore/plot/base/Aesthetics;ILjava/lang/Double;)Ljetbrains/datalore/plot/base/PositionAdjustment;", "dodgev", "height", "fill", "vjust", "stackingMode", "Ljetbrains/datalore/plot/base/pos/StackingMode;", "(Ljetbrains/datalore/plot/base/Aesthetics;Ljava/lang/Double;Ljetbrains/datalore/plot/base/pos/StackingMode;)Ljetbrains/datalore/plot/base/PositionAdjustment;", "identity", "jitter", "(Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/plot/base/PositionAdjustment;", "jitterDodge", "jitterWidth", "jitterHeight", "(Ljetbrains/datalore/plot/base/Aesthetics;ILjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/plot/base/PositionAdjustment;", "nudge", "stack", "aes", "Meta", "plot-base-portable"})
public final class PositionAdjustments {
    @NotNull
    public static final PositionAdjustments INSTANCE = new PositionAdjustments();

    private PositionAdjustments() {
    }

    @NotNull
    public final PositionAdjustment identity() {
        return new PositionAdjustment(){

            public boolean isIdentity() {
                return true;
            }

            @NotNull
            public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return v;
            }

            public boolean handlesGroups() {
                return Meta.IDENTITY.handlesGroups();
            }
        };
    }

    @NotNull
    public final PositionAdjustment dodge(@NotNull Aesthetics aesthetics, int groupCount, @Nullable Double width2) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        return new DodgePos(aesthetics, groupCount, width2);
    }

    @NotNull
    public final PositionAdjustment dodgev(@NotNull Aesthetics aesthetics, int groupCount, @Nullable Double height) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        return new DodgeVPos(aesthetics, groupCount, height);
    }

    @NotNull
    public final PositionAdjustment stack(@NotNull Aesthetics aes, @Nullable Double vjust, @NotNull StackingMode stackingMode) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)((Object)stackingMode), (String)"stackingMode");
        return new StackPos(aes, vjust, stackingMode);
    }

    @NotNull
    public final PositionAdjustment fill(@NotNull Aesthetics aesthetics, @Nullable Double vjust, @NotNull StackingMode stackingMode) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)((Object)stackingMode), (String)"stackingMode");
        return new FillPos(aesthetics, vjust, stackingMode);
    }

    @NotNull
    public final PositionAdjustment jitter(@Nullable Double width2, @Nullable Double height) {
        return new JitterPos(width2, height);
    }

    @NotNull
    public final PositionAdjustment nudge(@Nullable Double width2, @Nullable Double height) {
        return new NudgePos(width2, height);
    }

    @NotNull
    public final PositionAdjustment jitterDodge(@NotNull Aesthetics aesthetics, int groupCount, @Nullable Double width2, @Nullable Double jitterWidth, @Nullable Double jitterHeight) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        return new JitterDodgePos(aesthetics, groupCount, width2, jitterWidth, jitterHeight);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/pos/PositionAdjustments$Meta;", "", "handlesGroups", "", "(Ljava/lang/String;IZ)V", "IDENTITY", "DODGE", "STACK", "FILL", "JITTER", "NUDGE", "JITTER_DODGE", "plot-base-portable"})
    public static final class Meta
    extends Enum<Meta> {
        private final boolean handlesGroups;
        public static final /* enum */ Meta IDENTITY = new Meta(false);
        public static final /* enum */ Meta DODGE = new Meta(true);
        public static final /* enum */ Meta STACK = new Meta(true);
        public static final /* enum */ Meta FILL = new Meta(true);
        public static final /* enum */ Meta JITTER = new Meta(false);
        public static final /* enum */ Meta NUDGE = new Meta(false);
        public static final /* enum */ Meta JITTER_DODGE = new Meta(true);
        private static final /* synthetic */ Meta[] $VALUES;

        private Meta(boolean handlesGroups) {
            this.handlesGroups = handlesGroups;
        }

        public final boolean handlesGroups() {
            return this.handlesGroups;
        }

        public static Meta[] values() {
            return (Meta[])$VALUES.clone();
        }

        public static Meta valueOf(String value) {
            return Enum.valueOf(Meta.class, value);
        }

        static {
            $VALUES = metaArray = new Meta[]{Meta.IDENTITY, Meta.DODGE, Meta.STACK, Meta.FILL, Meta.JITTER, Meta.NUDGE, Meta.JITTER_DODGE};
        }
    }
}

