/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.render.linetype.LineType;
import jetbrains.datalore.plot.base.render.svg.StrokeDashArraySupport;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgShape;
import jetbrains.datalore.vis.svg.slim.SvgSlimShape;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0016\u0018\u0000 '2\u00020\u0001:\u0002'(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0000J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001dH\u0004J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013J1\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001d2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001dH\u0000\u00a2\u0006\u0002\b$J-\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001dH\u0000\u00a2\u0006\u0002\b&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "getCoord", "()Ljetbrains/datalore/plot/base/CoordinateSystem;", "getCtx$plot_base_portable", "()Ljetbrains/datalore/plot/base/GeomContext;", "getPos", "()Ljetbrains/datalore/plot/base/PositionAdjustment;", "adjust", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "r", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "location", "createSvgElementHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper$SvgElementHelper;", "project", "", "dataPoints", "", "projection", "Lkotlin/Function1;", "toClient", "x", "", "y", "toClientLocation", "aesMapper", "toClientLocation$plot_base_portable", "toClientRect", "toClientRect$plot_base_portable", "Companion", "SvgElementHelper", "plot-base-portable"})
public class GeomHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PositionAdjustment pos;
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final GeomContext ctx;

    public GeomHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.pos = pos;
        this.coord = coord;
        this.ctx = ctx;
    }

    @NotNull
    protected final PositionAdjustment getPos() {
        return this.pos;
    }

    @NotNull
    protected final CoordinateSystem getCoord() {
        return this.coord;
    }

    @NotNull
    public final GeomContext getCtx$plot_base_portable() {
        return this.ctx;
    }

    @Nullable
    public final DoubleVector toClient(@NotNull DoubleVector location, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coord.toClient(this.adjust(location, p, this.pos, this.ctx));
    }

    @Nullable
    public final DoubleVector toClient(double x, double y, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector location = new DoubleVector(x, y);
        return this.coord.toClient(this.adjust(location, p, this.pos, this.ctx));
    }

    @Nullable
    public final DoubleRectangle toClient(@NotNull DoubleRectangle r, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleRectangle clientRect = this.coord.toClient(this.adjust(r, p, this.pos, this.ctx));
        if (clientRect == null) {
            return null;
        }
        if (clientRect.getWidth() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), 0.1, clientRect.getHeight());
        }
        if (clientRect.getHeight() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), clientRect.getWidth(), 0.1);
        }
        return clientRect;
    }

    private final DoubleVector adjust(DoubleVector location, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx) {
        return pos.translate(location, p, ctx);
    }

    @Nullable
    public final DoubleRectangle toClientRect$plot_base_portable(@NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> aesMapper) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        DoubleRectangle doubleRectangle = (DoubleRectangle)aesMapper.invoke((Object)p);
        if (doubleRectangle == null) {
            return null;
        }
        DoubleRectangle r = doubleRectangle;
        return this.toClient(r, p);
    }

    private final DoubleRectangle adjust(DoubleRectangle r, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx) {
        DoubleVector leftTop = pos.translate(r.getOrigin(), p, ctx);
        DoubleVector rightBottom = pos.translate(r.getOrigin().add(r.getDimension()), p, ctx);
        return DoubleRectangle.Companion.span(leftTop, rightBottom);
    }

    @NotNull
    protected final List<DoubleVector> project(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> projection) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(projection, (String)"projection");
        ArrayList<DoubleVector> points = new ArrayList<DoubleVector>();
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            DoubleVector pp;
            DoubleVector location = (DoubleVector)projection.invoke((Object)dataPointAesthetics);
            if (location == null || (pp = this.toClient(location, dataPointAesthetics)) == null) continue;
            points.add(pp);
        }
        return points;
    }

    @NotNull
    public final Function1<DataPointAesthetics, DoubleVector> toClientLocation$plot_base_portable(@NotNull Function1<? super DataPointAesthetics, DoubleVector> aesMapper) {
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(aesMapper, this){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $aesMapper;
            final /* synthetic */ GeomHelper this$0;
            {
                this.$aesMapper = $aesMapper;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics aes) {
                Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
                DoubleVector location = (DoubleVector)this.$aesMapper.invoke((Object)aes);
                return location != null ? this.this$0.toClient(location, aes) : null;
            }
        };
    }

    @NotNull
    public final SvgElementHelper createSvgElementHelper() {
        return new SvgElementHelper();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper$SvgElementHelper;", "", "(Ljetbrains/datalore/plot/base/geom/util/GeomHelper;)V", "myStrokeAlphaEnabled", "", "createLine", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "start", "Ljetbrains/datalore/base/geometry/DoubleVector;", "end", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "setStrokeAlphaEnabled", "", "b", "plot-base-portable"})
    public final class SvgElementHelper {
        private boolean myStrokeAlphaEnabled;

        public final void setStrokeAlphaEnabled(boolean b2) {
            this.myStrokeAlphaEnabled = b2;
        }

        @Nullable
        public final SvgLineElement createLine(@NotNull DoubleVector start, @NotNull DoubleVector end, @NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            DoubleVector start2 = GeomHelper.this.toClient(start, p);
            if (start2 == null) {
                return null;
            }
            DoubleVector end2 = GeomHelper.this.toClient(end, p);
            if (end2 == null) {
                return null;
            }
            SvgLineElement line = new SvgLineElement(start2.getX(), start2.getY(), end2.getX(), end2.getY());
            jetbrains.datalore.plot.base.geom.util.GeomHelper$Companion.decorate$default(Companion, (SvgNode)line, p, this.myStrokeAlphaEnabled, null, 8, null);
            return line;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fJ4\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001d\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper$Companion;", "", "()V", "decorate", "", "node", "Ljetbrains/datalore/vis/svg/SvgNode;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "applyAlphaToAll", "", "strokeScaler", "Lkotlin/Function1;", "", "decorateShape", "shape", "Ljetbrains/datalore/vis/svg/SvgShape;", "decorateSlimShape", "Ljetbrains/datalore/vis/svg/slim/SvgSlimShape;", "decorateSlimShape$plot_base_portable", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public final void decorate(@NotNull SvgNode node, @NotNull DataPointAesthetics p, boolean applyAlphaToAll, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            LineType lineType;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            if (node instanceof SvgShape) {
                this.decorateShape((SvgShape)node, p, applyAlphaToAll, strokeScaler);
            }
            if (node instanceof SvgElement && !(lineType = p.lineType()).isBlank() && !lineType.isSolid()) {
                StrokeDashArraySupport.INSTANCE.apply((SvgElement)node, ((Number)strokeScaler.invoke((Object)p)).doubleValue(), lineType.getDashArray());
            }
        }

        public static /* synthetic */ void decorate$default(Companion companion, SvgNode svgNode, DataPointAesthetics dataPointAesthetics, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            companion.decorate(svgNode, dataPointAesthetics, bl, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        private final void decorateShape(SvgShape shape, DataPointAesthetics p, boolean applyAlphaToAll, Function1<? super DataPointAesthetics, Double> strokeScaler) {
            AestheticsUtil.INSTANCE.updateStroke(shape, p, applyAlphaToAll);
            AestheticsUtil.INSTANCE.updateFill(shape, p);
            shape.strokeWidth().set(strokeScaler.invoke((Object)p));
        }

        public final void decorateSlimShape$plot_base_portable(@NotNull SvgSlimShape shape, @NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Color color = p.color();
            Intrinsics.checkNotNull((Object)color);
            Color stroke = color;
            double strokeAlpha = AestheticsUtil.INSTANCE.alpha(stroke, p);
            Color color2 = p.fill();
            Intrinsics.checkNotNull((Object)color2);
            Color fill = color2;
            double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill, p);
            shape.setFill(fill, fillAlpha);
            shape.setStroke(stroke, strokeAlpha);
            shape.setStrokeWidth(AesScaling.INSTANCE.strokeWidth(p));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

