/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.geom.util.MultiPointData;
import jetbrains.datalore.plot.base.geom.util.MultiPointDataConstructor;
import jetbrains.datalore.plot.base.geom.util.QuantilesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.stat.YDensityStat;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'0#H\u0002J0\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u00101\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u00102\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J3\u00107\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'0#2\u0006\u00108\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\u0018\u00a8\u0006:"}, d2={"Ljetbrains/datalore/plot/base/geom/ViolinGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "negativeSign", "", "getNegativeSign", "()D", "positiveSign", "getPositiveSign", "quantileLines", "", "getQuantileLines", "()Z", "setQuantileLines", "(Z)V", "quantiles", "", "getQuantiles", "()Ljava/util/List;", "setQuantiles", "(Ljava/util/List;)V", "showHalf", "getShowHalf", "setShowHalf", "(D)V", "buildHints", "", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "boundTransform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "p", "Ljetbrains/datalore/base/geometry/DoubleVector;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildLines", "buildViolin", "createQuantileLines", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "quantilesHelper", "Ljetbrains/datalore/plot/base/geom/util/QuantilesHelper;", "toLocationBound", "sign", "Companion", "plot-base-portable"})
public final class ViolinGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Double> quantiles = YDensityStat.Companion.getDEF_QUANTILES();
    private boolean quantileLines;
    private double showHalf;
    public static final boolean DEF_QUANTILE_LINES = false;
    public static final double DEF_SHOW_HALF = 0.0;
    public static final boolean HANDLES_GROUPS = true;

    @NotNull
    public final List<Double> getQuantiles() {
        return this.quantiles;
    }

    public final void setQuantiles(@NotNull List<Double> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.quantiles = list2;
    }

    public final boolean getQuantileLines() {
        return this.quantileLines;
    }

    public final void setQuantileLines(boolean bl) {
        this.quantileLines = bl;
    }

    public final double getShowHalf() {
        return this.showHalf;
    }

    public final void setShowHalf(double d) {
        this.showHalf = d;
    }

    private final double getNegativeSign() {
        return this.showHalf > 0.0 ? 0.0 : -1.0;
    }

    private final double getPositiveSign() {
        return this.showHalf < 0.0 ? 0.0 : 1.0;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.buildLines(root, aesthetics, pos, coord, ctx);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLines(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getVIOLINWIDTH(), Aes.Companion.getWIDTH());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double key$iv$iv = p0.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Double x = (Double)entry.getKey();
            List nonOrderedPoints = (List)entry.getValue();
            object.add(TuplesKt.to((Object)x, GeomUtil.INSTANCE.ordered_Y(nonOrderedPoints, false)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Iterable dataPoints2 = (Iterable)pair.component2();
            this.buildViolin(root, dataPoints2, pos, coord, ctx);
        }
    }

    private final void buildViolin(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        LinesHelper helper = new LinesHelper(pos, coord, ctx);
        QuantilesHelper quantilesHelper = new QuantilesHelper(pos, coord, ctx, this.quantiles, Aes.Companion.getX());
        Function1<DataPointAesthetics, DoubleVector> leftBoundTransform = this.toLocationBound(this.getNegativeSign(), ctx);
        Function1<DataPointAesthetics, DoubleVector> rightBoundTransform = this.toLocationBound(this.getPositiveSign(), ctx);
        Iterable $this$forEach$iv = quantilesHelper.splitByQuantiles$plot_base_portable(dataPoints2, Aes.Companion.getY());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List points = (List)element$iv;
            boolean bl = false;
            List paths2 = LinesHelper.createBands$default(helper, points, leftBoundTransform, rightBoundTransform, false, 8, null);
            GeomBase.Companion.appendNodes(paths2, root);
            helper.setAlphaEnabled(false);
            GeomBase.Companion.appendNodes(helper.createLines(points, leftBoundTransform), root);
            GeomBase.Companion.appendNodes(helper.createLines(points, rightBoundTransform), root);
            this.buildHints(points, ctx, helper, leftBoundTransform);
            this.buildHints(points, ctx, helper, rightBoundTransform);
        }
        if (this.quantileLines) {
            $this$forEach$iv = this.createQuantileLines(dataPoints2, quantilesHelper, ctx);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement quantileLine = (SvgLineElement)element$iv;
                boolean bl = false;
                root.add((SvgNode)quantileLine);
            }
        }
    }

    private final List<SvgLineElement> createQuantileLines(Iterable<? extends DataPointAesthetics> dataPoints2, QuantilesHelper quantilesHelper, GeomContext ctx) {
        Function1 toLocationBoundStart2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, ctx){
            final /* synthetic */ ViolinGeom this$0;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                double d = ((DoubleVector)ViolinGeom.access$toLocationBound(this.this$0, ViolinGeom.access$getNegativeSign(this.this$0), this.$ctx).invoke((Object)p)).getX();
                Double d2 = p.y();
                Intrinsics.checkNotNull((Object)d2);
                return new DoubleVector(d, d2.doubleValue());
            }
        };
        Function1 toLocationBoundEnd2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, ctx){
            final /* synthetic */ ViolinGeom this$0;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                double d = ((DoubleVector)ViolinGeom.access$toLocationBound(this.this$0, ViolinGeom.access$getPositiveSign(this.this$0), this.$ctx).invoke((Object)p)).getX();
                Double d2 = p.y();
                Intrinsics.checkNotNull((Object)d2);
                return new DoubleVector(d, d2.doubleValue());
            }
        };
        return quantilesHelper.getQuantileLineElements$plot_base_portable(dataPoints2, Aes.Companion.getY(), (Function1<? super DataPointAesthetics, DoubleVector>)toLocationBoundStart2, (Function1<? super DataPointAesthetics, DoubleVector>)toLocationBoundEnd2);
    }

    private final Function1<DataPointAesthetics, DoubleVector> toLocationBound(double sign, GeomContext ctx) {
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(ctx, sign){
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ double $sign;
            {
                this.$ctx = $ctx;
                this.$sign = $sign;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Double d = p.x();
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                double d3 = this.$ctx.getResolution(Aes.Companion.getX()) / (double)2 * this.$sign;
                Double d4 = p.width();
                Intrinsics.checkNotNull((Object)d4);
                double d5 = d3 * d4;
                Double d6 = p.violinwidth();
                Intrinsics.checkNotNull((Object)d6);
                double x = d2 + d5 * d6;
                Double d7 = p.y();
                Intrinsics.checkNotNull((Object)d7);
                double y = d7;
                return new DoubleVector(x, y);
            }
        };
    }

    private final void buildHints(Iterable<? extends DataPointAesthetics> dataPoints2, GeomContext ctx, GeomHelper helper, Function1<? super DataPointAesthetics, DoubleVector> boundTransform) {
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender((Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(boundTransform, helper){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $boundTransform;
            final /* synthetic */ GeomHelper $helper;
            {
                this.$boundTransform = $boundTransform;
                this.$helper = $helper;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Object object = this.$boundTransform.invoke((Object)p);
                GeomHelper geomHelper = this.$helper;
                DoubleVector it = (DoubleVector)object;
                boolean bl = false;
                return geomHelper.toClient(it, p);
            }
        })), MultiPointDataConstructor.INSTANCE.reducer(0.999, false));
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx);
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.VIOLIN, ctx);
        for (MultiPointData multiPointData : multiPointDataList2) {
            targetCollector.addPath(multiPointData.getPoints(), multiPointData.getLocalToGlobalIndex(), new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)multiPointData.getAes()), 7, null), ctx.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
        }
    }

    public static final /* synthetic */ Function1 access$toLocationBound(ViolinGeom $this, double sign, GeomContext ctx) {
        return $this.toLocationBound(sign, ctx);
    }

    public static final /* synthetic */ double access$getNegativeSign(ViolinGeom $this) {
        return $this.getNegativeSign();
    }

    public static final /* synthetic */ double access$getPositiveSign(ViolinGeom $this) {
        return $this.getPositiveSign();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/geom/ViolinGeom$Companion;", "", "()V", "DEF_QUANTILE_LINES", "", "DEF_SHOW_HALF", "", "HANDLES_GROUPS", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

