/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.coord;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.spatial.projections.Projection;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.Mappers;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB;\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/coord/CoordinatesMapper;", "", "hScaleMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "", "vScaleMapper", "clientBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "projection", "Ljetbrains/datalore/base/spatial/projections/Projection;", "flipAxis", "", "(Ljetbrains/datalore/plot/base/ScaleMapper;Ljetbrains/datalore/plot/base/ScaleMapper;Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljetbrains/datalore/base/spatial/projections/Projection;Z)V", "cachedUnitSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getClientBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getHScaleMapper", "()Ljetbrains/datalore/plot/base/ScaleMapper;", "getProjection$plot_base_portable", "()Ljetbrains/datalore/base/spatial/projections/Projection;", "getVScaleMapper", "flip", "toClient", "p", "unitSize", "unitSizeIntern", "Companion", "plot-base-portable"})
public final class CoordinatesMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleMapper<Double> hScaleMapper;
    @NotNull
    private final ScaleMapper<Double> vScaleMapper;
    @NotNull
    private final DoubleRectangle clientBounds;
    @NotNull
    private final Projection projection;
    private final boolean flipAxis;
    @Nullable
    private DoubleVector cachedUnitSize;

    private CoordinatesMapper(ScaleMapper<Double> hScaleMapper, ScaleMapper<Double> vScaleMapper, DoubleRectangle clientBounds, Projection projection, boolean flipAxis) {
        this.hScaleMapper = hScaleMapper;
        this.vScaleMapper = vScaleMapper;
        this.clientBounds = clientBounds;
        this.projection = projection;
        this.flipAxis = flipAxis;
    }

    @NotNull
    public final ScaleMapper<Double> getHScaleMapper() {
        return this.hScaleMapper;
    }

    @NotNull
    public final ScaleMapper<Double> getVScaleMapper() {
        return this.vScaleMapper;
    }

    @NotNull
    public final DoubleRectangle getClientBounds() {
        return this.clientBounds;
    }

    @NotNull
    public final Projection getProjection$plot_base_portable() {
        return this.projection;
    }

    @Nullable
    public final DoubleVector toClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector projected = this.projection.project(p);
        if (projected != null) {
            Double mappedX = this.hScaleMapper.invoke(!this.flipAxis ? projected.getX() : projected.getY());
            Double mappedY = this.vScaleMapper.invoke(!this.flipAxis ? projected.getY() : projected.getX());
            if (mappedX != null && mappedY != null) {
                return new DoubleVector(mappedX.doubleValue(), mappedY.doubleValue());
            }
        }
        return null;
    }

    @NotNull
    public final DoubleVector unitSize(@NotNull DoubleVector p) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.projection.getNonlinear()) {
            doubleVector = this.unitSizeIntern(p);
        } else {
            if (this.cachedUnitSize == null) {
                this.cachedUnitSize = this.unitSizeIntern(p);
            }
            DoubleVector doubleVector2 = this.cachedUnitSize;
            doubleVector = doubleVector2;
            Intrinsics.checkNotNull((Object)doubleVector2);
        }
        return doubleVector;
    }

    private final DoubleVector unitSizeIntern(DoubleVector p) {
        DoubleVector c = Companion.toValidUnitSquareCenter(p, this.projection);
        CoordinatesMapper $this$unitSizeIntern_u24lambda_u240 = this;
        boolean bl = false;
        DoubleVector doubleVector = $this$unitSizeIntern_u24lambda_u240.toClient(new DoubleVector(c.getX() - 0.5, c.getY()));
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector p0 = doubleVector;
        DoubleVector doubleVector2 = $this$unitSizeIntern_u24lambda_u240.toClient(new DoubleVector(c.getX() + 0.5, c.getY()));
        Intrinsics.checkNotNull((Object)doubleVector2);
        DoubleVector p1 = doubleVector2;
        double width2 = p1.subtract(p0).length();
        CoordinatesMapper $this$unitSizeIntern_u24lambda_u241 = this;
        boolean bl2 = false;
        DoubleVector doubleVector3 = $this$unitSizeIntern_u24lambda_u241.toClient(new DoubleVector(c.getX(), c.getY() - 0.5));
        Intrinsics.checkNotNull((Object)doubleVector3);
        DoubleVector p02 = doubleVector3;
        DoubleVector doubleVector4 = $this$unitSizeIntern_u24lambda_u241.toClient(new DoubleVector(c.getX(), c.getY() + 0.5));
        Intrinsics.checkNotNull((Object)doubleVector4);
        DoubleVector p12 = doubleVector4;
        double height = p12.subtract(p02).length();
        return new DoubleVector(width2, height);
    }

    @NotNull
    public final CoordinatesMapper flip() {
        return new CoordinatesMapper(this.hScaleMapper, this.vScaleMapper, this.clientBounds, this.projection, !this.flipAxis);
    }

    public /* synthetic */ CoordinatesMapper(ScaleMapper hScaleMapper, ScaleMapper vScaleMapper, DoubleRectangle clientBounds, Projection projection, boolean flipAxis, DefaultConstructorMarker $constructor_marker) {
        this(hScaleMapper, vScaleMapper, clientBounds, projection, flipAxis);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/coord/CoordinatesMapper$Companion;", "", "()V", "create", "Ljetbrains/datalore/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "clientSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "projection", "Ljetbrains/datalore/base/spatial/projections/Projection;", "flipAxis", "", "toValidUnitSquareCenter", "p", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoordinatesMapper create(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize, @NotNull Projection projection, boolean flipAxis) {
            DoubleRectangle doubleRectangle;
            DoubleRectangle doubleRectangle2;
            Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
            Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
            Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
            boolean bl = flipAxis;
            if (bl) {
                doubleRectangle2 = adjustedDomain.flip();
            } else if (!bl) {
                doubleRectangle2 = adjustedDomain;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleRectangle validDomain = doubleRectangle2;
            DoubleVector leftTop = projection.project(validDomain.getOrigin());
            if (!(leftTop != null)) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$52 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$52 = "Can't project domain left-top: " + validDomain.getOrigin();
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$52.toString());
            }
            DoubleVector domainRB = validDomain.getOrigin().add(validDomain.getDimension());
            DoubleVector rightBottom = projection.project(domainRB);
            if (!(rightBottom != null)) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$62 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$62 = "Can't project domain right-bottom: " + domainRB;
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$62.toString());
            }
            DoubleRectangle it = DoubleRectangle.Companion.span(leftTop, rightBottom);
            boolean bl2 = false;
            boolean bl3 = flipAxis;
            if (bl3) {
                doubleRectangle = it.flip();
            } else if (!bl3) {
                doubleRectangle = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleRectangle domainProjected = doubleRectangle;
            if (!(!(domainProjected.xRange().getLength() == 0.0))) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$72 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$72 = "Can't create coordinates mapper: X-domain size is 0.0";
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$72.toString());
            }
            if (!(!(domainProjected.yRange().getLength() == 0.0))) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$82 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$82 = "Can't create coordinates mapper: Y-domain size is 0.0";
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$82.toString());
            }
            ScaleMapper<Double> hScaleMapper = Mappers.INSTANCE.mul(domainProjected.xRange(), clientSize.getX());
            ScaleMapper<Double> vScaleMapper = Mappers.INSTANCE.mul(domainProjected.yRange(), clientSize.getY());
            Double d = hScaleMapper.invoke(domainProjected.getOrigin().getX());
            Intrinsics.checkNotNull((Object)d);
            double d2 = ((Number)d).doubleValue();
            Double d3 = vScaleMapper.invoke(domainProjected.getOrigin().getY());
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector clientOrigin = new DoubleVector(d2, ((Number)d3).doubleValue());
            DoubleRectangle clientBounds = new DoubleRectangle(clientOrigin, clientSize);
            return new CoordinatesMapper(hScaleMapper, vScaleMapper, clientBounds, projection, flipAxis, null);
        }

        @NotNull
        public final DoubleVector toValidUnitSquareCenter(@NotNull DoubleVector p, @NotNull Projection projection) {
            double x;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
            DoubleRectangle validDomain = projection.validDomain();
            double d = p.getX() < validDomain.getLeft() + 0.5 ? validDomain.getLeft() + 0.5 : (x = p.getX() > validDomain.getRight() - 0.5 ? validDomain.getRight() - 0.5 : p.getX());
            double y = p.getY() < validDomain.getTop() + 0.5 ? validDomain.getTop() + 0.5 : (p.getY() > validDomain.getBottom() - 0.5 ? validDomain.getBottom() - 0.5 : p.getY());
            return new DoubleVector(x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

