/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParsePosition;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;

public class DarkFormattedTextFieldUI
extends DarkTextFieldUI
implements PropertyChangeListener,
DocumentListener {
    private JFormattedTextField textField;

    public static ComponentUI createUI(JComponent c) {
        return new DarkFormattedTextFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "FormattedTextField";
    }

    @Override
    public void installUI(JComponent c) {
        this.textField = (JFormattedTextField)c;
        super.installUI(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("document".equals(evt.getPropertyName())) {
            Object oldDoc = evt.getOldValue();
            Object newDoc = evt.getNewValue();
            if (oldDoc instanceof Document) {
                ((Document)oldDoc).removeDocumentListener(this);
            }
            if (newDoc instanceof Document) {
                ((Document)newDoc).addDocumentListener(this);
            }
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.textField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.textField.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this::update);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this::update);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    protected void update() {
        if (this.textField == null) {
            return;
        }
        this.textField.putClientProperty("JTextComponent.hasError", !this.isInputValid(this.textField));
    }

    protected boolean isInputValid(JFormattedTextField textField) {
        String value = textField.getText();
        JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
        if (formatter instanceof InternationalFormatter) {
            Format format = ((InternationalFormatter)formatter).getFormat();
            ParsePosition position = new ParsePosition(0);
            format.parseObject(value, position);
            return position.getIndex() == value.length();
        }
        return textField.isEditValid();
    }
}

