/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.FacetedPlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.PlotAxisLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutProvider;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/layout/facet/FreeScalesTilesLayouter;", "", "()V", "createTileLayoutInfos", "", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "tilesAreaSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "layoutProviderByTile", "Ljetbrains/datalore/plot/builder/layout/TileLayoutProvider;", "addedHSize", "", "addedVSize", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "hAxisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "vAxisTheme", "plot-builder-portable"})
public final class FreeScalesTilesLayouter {
    @NotNull
    public static final FreeScalesTilesLayouter INSTANCE = new FreeScalesTilesLayouter();

    private FreeScalesTilesLayouter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TileLayoutInfo> createTileLayoutInfos(@NotNull DoubleVector tilesAreaSize, @NotNull PlotFacets facets, @NotNull List<? extends TileLayoutProvider> layoutProviderByTile, double addedHSize, double addedVSize, @NotNull CoordProvider coordProvider, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)tilesAreaSize, (String)"tilesAreaSize");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        List<PlotFacets.FacetTileInfo> facetTiles = facets.tileInfos();
        int vAxisCount = FacetedPlotLayoutUtil.INSTANCE.countVAxisInFirstRow(facetTiles);
        double vAxisThickness = PlotAxisLayoutUtil.INSTANCE.initialThickness(Orientation.LEFT, vAxisTheme);
        double geomWidth = (tilesAreaSize.getX() - addedHSize - (double)vAxisCount * vAxisThickness) / (double)facets.getColCount();
        int hAxisCount = FacetedPlotLayoutUtil.INSTANCE.countHAxisInFirstCol(facetTiles);
        double hAxisThickness = PlotAxisLayoutUtil.INSTANCE.initialThickness(Orientation.BOTTOM, hAxisTheme);
        double geomHeight = (tilesAreaSize.getY() - addedVSize - (double)hAxisCount * hAxisThickness) / (double)facets.getRowCount();
        Iterable $this$map$iv = layoutProviderByTile;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            TileLayoutProvider tileLayoutProvider = (TileLayoutProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createInsideOutTileLayout());
        }
        List layoutByTile = (List)destination$iv$iv;
        Iterable $this$map$iv2 = facetTiles;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            PlotFacets.FacetTileInfo bl = (PlotFacets.FacetTileInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new Pair((Object)it, layoutByTile.get(it.getTrueIndex())));
        }
        List facetTileAndLayout = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = facetTileAndLayout;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Pair bl2 = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            PlotFacets.FacetTileInfo facetTile = (PlotFacets.FacetTileInfo)bl2.component1();
            TileLayout tileLayout = (TileLayout)bl2.component2();
            collection.add(tileLayout.doLayout(new DoubleVector(geomWidth, geomHeight), coordProvider).withAxisShown(facetTile.getHasHAxis(), facetTile.getHasVAxis()));
        }
        List layoutInfos = (List)destination$iv$iv3;
        DoubleVector tilesAreaSizeNew = FacetedPlotLayoutUtil.INSTANCE.tilesAreaSize(layoutInfos, facets, addedHSize, addedVSize);
        double widthDiff = tilesAreaSize.getX() - tilesAreaSizeNew.getX();
        double heightDiff = tilesAreaSize.getY() - tilesAreaSizeNew.getY();
        if (Math.abs(widthDiff) <= (double)facets.getColCount() && Math.abs(heightDiff) <= (double)facets.getRowCount()) {
            return layoutInfos;
        }
        double geomWidthDelta = widthDiff / (double)facets.getColCount();
        double geomHeightDelta = heightDiff / (double)facets.getRowCount();
        double geomWidth2 = geomWidth + geomWidthDelta;
        double geomHeight2 = geomHeight + geomHeightDelta;
        Iterable $this$map$iv4 = facetTileAndLayout;
        boolean $i$f$map4 = false;
        Iterable iterable2 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            PlotFacets.FacetTileInfo facetTile = (PlotFacets.FacetTileInfo)pair.component1();
            TileLayout tileLayout = (TileLayout)pair.component2();
            collection.add(tileLayout.doLayout(new DoubleVector(geomWidth2, geomHeight2), coordProvider).withAxisShown(facetTile.getHasHAxis(), facetTile.getHasVAxis()));
        }
        List layoutInfos2 = (List)destination$iv$iv4;
        return layoutInfos2;
    }
}

