/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact.loc;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.loc.PathTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PointTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.RectTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetDetector;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/TargetDetector;", "", "locatorLookupSpace", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;", "locatorLookupStrategy", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupStrategy;", "(Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupStrategy;)V", "checkPath", "Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection$PathPoint;", "cursorCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "pathProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection;", "closestPointChecker", "Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker;", "checkPoint", "", "pointProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PointTargetProjection;", "checkPolygon", "polygonProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "checkRect", "rectProjection", "Ljetbrains/datalore/plot/builder/interact/loc/RectTargetProjection;", "rangeBasedLookup", "cursor", "range", "Ljetbrains/datalore/base/interval/DoubleSpan;", "byX", "Companion", "plot-builder-portable"})
public final class TargetDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeomTargetLocator.LookupSpace locatorLookupSpace;
    @NotNull
    private final GeomTargetLocator.LookupStrategy locatorLookupStrategy;
    private static final double POINT_AREA_EPSILON = 0.1;
    private static final double RECT_X_NEAREST_EPSILON = 2.0;

    public TargetDetector(@NotNull GeomTargetLocator.LookupSpace locatorLookupSpace, @NotNull GeomTargetLocator.LookupStrategy locatorLookupStrategy) {
        Intrinsics.checkNotNullParameter((Object)locatorLookupSpace, (String)"locatorLookupSpace");
        Intrinsics.checkNotNullParameter((Object)locatorLookupStrategy, (String)"locatorLookupStrategy");
        this.locatorLookupSpace = locatorLookupSpace;
        this.locatorLookupStrategy = locatorLookupStrategy;
    }

    @Nullable
    public final PathTargetProjection.PathPoint checkPath(@NotNull DoubleVector cursorCoord, @NotNull PathTargetProjection pathProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        PathTargetProjection.PathPoint pathPoint;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pathProjection, (String)"pathProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        if (pathProjection.getPoints().isEmpty()) {
            return null;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                pathPoint = null;
                break;
            }
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        pathPoint = null;
                        break block0;
                    }
                    case 2: {
                        pathPoint = (PathTargetProjection.PathPoint)TargetDetector.Companion.searchNearest(cursorCoord.getX(), pathProjection.getPoints(), checkPath.1.INSTANCE);
                        break block0;
                    }
                    case 3: {
                        if (cursorCoord.getX() < ((PathTargetProjection.PathPoint)CollectionsKt.first(pathProjection.getPoints())).projection().x() || cursorCoord.getX() > ((PathTargetProjection.PathPoint)CollectionsKt.last(pathProjection.getPoints())).projection().x()) {
                            pathPoint = null;
                            break block0;
                        }
                        pathPoint = (PathTargetProjection.PathPoint)TargetDetector.Companion.searchNearest(cursorCoord.getX(), pathProjection.getPoints(), checkPath.2.INSTANCE);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        pathPoint = null;
                        break block0;
                    }
                    case 2: {
                        pathPoint = (PathTargetProjection.PathPoint)TargetDetector.Companion.searchNearest(cursorCoord.getY(), pathProjection.getPoints(), checkPath.3.INSTANCE);
                        break block0;
                    }
                    case 3: {
                        if (cursorCoord.getY() < ((PathTargetProjection.PathPoint)CollectionsKt.first(pathProjection.getPoints())).projection().y() || cursorCoord.getY() > ((PathTargetProjection.PathPoint)CollectionsKt.last(pathProjection.getPoints())).projection().y()) {
                            pathPoint = null;
                            break block0;
                        }
                        pathPoint = (PathTargetProjection.PathPoint)TargetDetector.Companion.searchNearest(cursorCoord.getY(), pathProjection.getPoints(), checkPath.4.INSTANCE);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        return null;
                    }
                    case 3: {
                        for (PathTargetProjection.PathPoint pathPoint2 : pathProjection.getPoints()) {
                            DoubleVector targetPointCoord = pathPoint2.projection().xy();
                            if (!MathUtil.INSTANCE.areEqual$plot_builder_portable(targetPointCoord, cursorCoord, 0.1)) continue;
                            return pathPoint2;
                        }
                        return null;
                    }
                    case 2: {
                        PathTargetProjection.PathPoint nearestPoint = null;
                        for (PathTargetProjection.PathPoint pathPoint3 : pathProjection.getPoints()) {
                            DoubleVector targetPointCoord = pathPoint3.projection().xy();
                            if (!closestPointChecker.check(targetPointCoord)) continue;
                            nearestPoint = pathPoint3;
                        }
                        return nearestPoint;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pathPoint;
    }

    public final boolean checkPoint(@NotNull DoubleVector cursorCoord, @NotNull PointTargetProjection pointProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pointProjection, (String)"pointProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder_portable(pointProjection.x(), cursorCoord.getX(), 0.1);
                        break block0;
                    }
                    case 2: {
                        bl = closestPointChecker.check(new DoubleVector(pointProjection.x(), 0.0));
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder_portable(pointProjection.y(), cursorCoord.getY(), 0.1);
                        break block0;
                    }
                    case 2: {
                        bl = closestPointChecker.check(new DoubleVector(0.0, pointProjection.y()));
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder_portable(pointProjection.xy(), cursorCoord, 0.1);
                        break block0;
                    }
                    case 2: {
                        bl = closestPointChecker.check(pointProjection.xy());
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean checkRect(@NotNull DoubleVector cursorCoord, @NotNull RectTargetProjection rectProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)rectProjection, (String)"rectProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, rectProjection.x(), true);
                break;
            }
            case 3: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, rectProjection.y(), false);
                break;
            }
            case 4: {
                DoubleRectangle rect2 = rectProjection.xy();
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = rect2.contains(cursorCoord);
                        break block0;
                    }
                    case 2: {
                        if (rect2.contains(cursorCoord)) {
                            bl = closestPointChecker.check(cursorCoord);
                            break block0;
                        }
                        double x = cursorCoord.getX() < rect2.getLeft() ? rect2.getLeft() : rect2.getRight();
                        double y = cursorCoord.getY() < rect2.getTop() ? rect2.getTop() : rect2.getBottom();
                        x = rect2.xRange().contains(cursorCoord.getX()) ? cursorCoord.getX() : x;
                        y = rect2.yRange().contains(cursorCoord.getY()) ? cursorCoord.getY() : y;
                        bl = closestPointChecker.check(new DoubleVector(x, y));
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean checkPolygon(@NotNull DoubleVector cursorCoord, @NotNull PolygonTargetProjection polygonProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)polygonProjection, (String)"polygonProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, polygonProjection.x(), true);
                break;
            }
            case 3: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, polygonProjection.y(), false);
                break;
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        int n;
                        Iterable $this$count$iv = polygonProjection.xy();
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                PolygonTargetProjection.RingXY it = (PolygonTargetProjection.RingXY)element$iv;
                                boolean bl2 = false;
                                if (!it.contains(cursorCoord) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        if (n % 2 != 0) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean rangeBasedLookup(DoubleVector cursor, MathUtil.ClosestPointChecker closestPointChecker, DoubleSpan range, boolean byX) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 3: {
                bl = range.contains(byX ? cursor.getX() : cursor.getY());
                break;
            }
            case 2: {
                double cursorCoord;
                double d = cursorCoord = byX ? cursor.getX() : cursor.getY();
                if (range.contains(cursorCoord - 2.0) || range.contains(cursorCoord + 2.0)) {
                    DoubleVector coord;
                    DoubleVector doubleVector = coord = byX ? new DoubleVector(range.getLowerEnd() + range.getLength() / (double)2, cursor.getY()) : new DoubleVector(cursor.getX(), range.getLowerEnd() + range.getLength() / (double)2);
                    if (closestPointChecker.compare(coord) != MathUtil.ClosestPointChecker.COMPARISON_RESULT.NEW_FARTHER) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/TargetDetector$Companion;", "", "()V", "POINT_AREA_EPSILON", "", "RECT_X_NEAREST_EPSILON", "searchNearest", "T", "value", "items", "", "mapper", "Lkotlin/Function1;", "(DLjava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T searchNearest(double value, List<? extends T> items, Function1<? super T, Double> mapper) {
            if (value < ((Number)mapper.invoke(CollectionsKt.first(items))).doubleValue()) {
                return (T)CollectionsKt.first(items);
            }
            if (value > ((Number)mapper.invoke(CollectionsKt.last(items))).doubleValue()) {
                return (T)CollectionsKt.last(items);
            }
            int lo = 0;
            int hi = CollectionsKt.getLastIndex(items);
            while (lo <= hi) {
                int mid = (hi + lo) / 2;
                double midValue = ((Number)mapper.invoke(items.get(mid))).doubleValue();
                if (value < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (value > midValue) {
                    lo = mid + 1;
                    continue;
                }
                return items.get(mid);
            }
            return ((Number)mapper.invoke(items.get(lo))).doubleValue() - value < value - ((Number)mapper.invoke(items.get(hi))).doubleValue() ? items.get(lo) : items.get(hi);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GeomTargetLocator.LookupStrategy.values().length];
            try {
                nArray[GeomTargetLocator.LookupStrategy.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupStrategy.NEAREST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupStrategy.HOVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GeomTargetLocator.LookupSpace.values().length];
            try {
                nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

