/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.DataFrame;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0002$%B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004J\u001a\u0010!\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00040\"R&\u0010\u0002\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\b\u0012\u00060\tR\u00020\u00000\bj\f\u0012\b\u0012\u00060\tR\u00020\u0000`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R%\u0010\u0014\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/builder/data/GroupMerger;", "", "aggregateOperation", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "groups", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/data/GroupMerger$ComparableGroup;", "Lkotlin/collections/ArrayList;", "isEmpty", "", "()Z", "orderSpecs", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "getOrderSpecs", "()Ljava/util/List;", "setOrderSpecs", "(Ljava/util/List;)V", "orderedGroups", "getOrderedGroups", "orderedGroups$delegate", "Lkotlin/Lazy;", "orderedGroupsIntialized", "addGroup", "", "groupId", "", "d", "Ljetbrains/datalore/plot/base/DataFrame;", "groupSize", "getGroupSizes", "getResultSeries", "", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "Companion", "ComparableGroup", "plot-builder-portable"})
public final class GroupMerger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final Function1<List<Double>, Double> aggregateOperation;
    public List<DataFrame.OrderSpec> orderSpecs;
    @NotNull
    private final ArrayList<ComparableGroup> groups;
    private boolean orderedGroupsIntialized;
    @NotNull
    private final Lazy orderedGroups$delegate;

    public GroupMerger(@Nullable Function1<? super List<Double>, Double> aggregateOperation) {
        this.aggregateOperation = aggregateOperation;
        this.groups = new ArrayList();
        this.orderedGroups$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayList<ComparableGroup>>(this){
            final /* synthetic */ GroupMerger this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ArrayList<ComparableGroup> invoke() {
                GroupMerger.access$setOrderedGroupsIntialized$p(this.this$0, true);
                Iterable $this$sortedBy$iv = GroupMerger.access$getGroups$p(this.this$0);
                boolean $i$f$sortedBy = false;
                List sortedById = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ComparableGroup it = (ComparableGroup)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getGroupId());
                        it = (ComparableGroup)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getGroupId()));
                    }
                });
                ArrayList<ComparableGroup> sortedTwoWays = new ArrayList<ComparableGroup>();
                for (ComparableGroup group : sortedById) {
                    int indexToInsert = GroupMerger.access$getCompanion$p().findIndexToInsert(group, (List<ComparableGroup>)sortedTwoWays, this.this$0.getOrderSpecs());
                    sortedTwoWays.add(indexToInsert, group);
                }
                return sortedTwoWays;
            }
        }));
    }

    @NotNull
    public final List<DataFrame.OrderSpec> getOrderSpecs() {
        List<DataFrame.OrderSpec> list = this.orderSpecs;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"orderSpecs");
        return null;
    }

    public final void setOrderSpecs(@NotNull List<DataFrame.OrderSpec> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.orderSpecs = list;
    }

    public final boolean isEmpty() {
        return this.groups.isEmpty();
    }

    private final List<ComparableGroup> getOrderedGroups() {
        Lazy lazy = this.orderedGroups$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<DataFrame.Variable, List<Object>> getResultSeries() {
        HashMap resultSeries = new HashMap();
        Iterable $this$forEach$iv = this.getOrderedGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComparableGroup group = (ComparableGroup)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = group.getDf().variables();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                DataFrame.Variable variable = (DataFrame.Variable)element$iv2;
                boolean bl2 = false;
                Map $this$getOrPut$iv = resultSeries;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(variable);
                if (value$iv == null) {
                    boolean bl3 = false;
                    ArrayList answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(variable, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).addAll(group.getDf().get(variable));
            }
        }
        return resultSeries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getGroupSizes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getOrderedGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ComparableGroup comparableGroup = (ComparableGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getGroupSize());
        }
        return (List)destination$iv$iv;
    }

    public final void addGroup(int groupId, @NotNull DataFrame d, int groupSize) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (!(!this.orderedGroupsIntialized)) {
            boolean bl = false;
            String string = "Can't any longer add a group";
            throw new IllegalStateException(string.toString());
        }
        ComparableGroup group = new ComparableGroup(groupId, d, groupSize);
        this.groups.add(group);
    }

    public static final /* synthetic */ void access$setOrderedGroupsIntialized$p(GroupMerger $this, boolean bl) {
        $this.orderedGroupsIntialized = bl;
    }

    public static final /* synthetic */ ArrayList access$getGroups$p(GroupMerger $this) {
        return $this.groups;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0004J2\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u00060\nR\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\nR\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rJ:\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142 \b\u0002\u0010\u0015\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\r\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0016\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/builder/data/GroupMerger$Companion;", "", "()V", "compareGroupValue", "", "v1", "v2", "dir", "findIndexToInsert", "group", "Ljetbrains/datalore/plot/builder/data/GroupMerger$ComparableGroup;", "Ljetbrains/datalore/plot/builder/data/GroupMerger;", "orderedGroups", "", "orderSpecs", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "getGroupValue", "df", "Ljetbrains/datalore/plot/base/DataFrame;", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "aggregateOperation", "Lkotlin/Function1;", "", "plot-builder-portable"})
    private static final class Companion {
        private Companion() {
        }

        public final int findIndexToInsert(@NotNull ComparableGroup group, @NotNull List<ComparableGroup> orderedGroups2, @NotNull List<DataFrame.OrderSpec> orderSpecs) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(orderedGroups2, (String)"orderedGroups");
            Intrinsics.checkNotNullParameter(orderSpecs, (String)"orderSpecs");
            if (orderSpecs.isEmpty()) {
                return orderedGroups2.size();
            }
            int index = CollectionsKt.binarySearch$default(orderedGroups2, (Comparable)group, (int)0, (int)0, (int)6, null);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
            return index;
        }

        public final int compareGroupValue(@Nullable Object v1, @Nullable Object v2, int dir) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return ComparisonsKt.compareValues((Comparable)((Comparable)v1), (Comparable)((Comparable)v2)) * dir;
        }

        @Nullable
        public final Object getGroupValue(@NotNull DataFrame df, @NotNull DataFrame.Variable variable, @Nullable Function1<? super List<Double>, Double> aggregateOperation) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)df, (String)"df");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            if (aggregateOperation != null) {
                if (!df.isNumeric(variable)) {
                    boolean bl = false;
                    String string = "Can't apply aggregate operation to non-numeric values";
                    throw new IllegalArgumentException(string.toString());
                }
                object = aggregateOperation.invoke((Object)CollectionsKt.requireNoNulls((List)df.getNumeric(variable)));
            } else {
                object = CollectionsKt.firstOrNull((List)df.get(variable));
            }
            return object;
        }

        public static /* synthetic */ Object getGroupValue$default(Companion companion, DataFrame dataFrame, DataFrame.Variable variable, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.getGroupValue(dataFrame, variable, (Function1<? super List<Double>, Double>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000e\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/data/GroupMerger$ComparableGroup;", "", "Ljetbrains/datalore/plot/builder/data/GroupMerger;", "groupId", "", "df", "Ljetbrains/datalore/plot/base/DataFrame;", "groupSize", "(Ljetbrains/datalore/plot/builder/data/GroupMerger;ILjetbrains/datalore/plot/base/DataFrame;I)V", "getDf", "()Ljetbrains/datalore/plot/base/DataFrame;", "getGroupId", "()I", "getGroupSize", "compareTo", "other", "plot-builder-portable"})
    public final class ComparableGroup
    implements Comparable<ComparableGroup> {
        private final int groupId;
        @NotNull
        private final DataFrame df;
        private final int groupSize;

        public ComparableGroup(@NotNull int groupId, DataFrame df, int groupSize) {
            Intrinsics.checkNotNullParameter((Object)df, (String)"df");
            this.groupId = groupId;
            this.df = df;
            this.groupSize = groupSize;
        }

        public final int getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final DataFrame getDf() {
            return this.df;
        }

        public final int getGroupSize() {
            return this.groupSize;
        }

        @Override
        public int compareTo(@NotNull ComparableGroup other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Iterable $this$forEach$iv = GroupMerger.this.getOrderSpecs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataFrame.OrderSpec spec = (DataFrame.OrderSpec)element$iv;
                boolean bl = false;
                int cmp = Companion.compareGroupValue(Companion.getGroupValue(this.df, spec.getOrderBy(), (Function1<? super List<Double>, Double>)spec.getAggregateOperation()), Companion.getGroupValue(other.df, spec.getOrderBy(), (Function1<? super List<Double>, Double>)spec.getAggregateOperation()), spec.getDirection());
                if (cmp == 0) {
                    cmp = Companion.compareGroupValue(jetbrains.datalore.plot.builder.data.GroupMerger$Companion.getGroupValue$default(Companion, this.df, spec.getVariable(), null, 4, null), jetbrains.datalore.plot.builder.data.GroupMerger$Companion.getGroupValue$default(Companion, other.df, spec.getVariable(), null, 4, null), spec.getDirection());
                }
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

