/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.AxisComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ@\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/AxisUtil;", "", "()V", "breaksData", "Ljetbrains/datalore/plot/builder/guide/AxisComponent$BreaksData;", "scaleBreaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "flipAxis", "", "horizontal", "toAxisCoord", "Lkotlin/Pair;", "", "", "", "plot-builder-portable"})
public final class AxisUtil {
    @NotNull
    public static final AxisUtil INSTANCE = new AxisUtil();

    private AxisUtil() {
    }

    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull CoordinateSystem coord, boolean flipAxis, boolean horizontal) {
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Pair<List<Double>, List<String>> pair = this.toAxisCoord(scaleBreaks, coord, flipAxis, horizontal);
        List breakCoords = (List)pair.component1();
        List breakLabels = (List)pair.component2();
        return new AxisComponent.BreaksData(breakCoords, breakLabels, null, 4, null);
    }

    private final Pair<List<Double>, List<String>> toAxisCoord(ScaleBreaks scaleBreaks, CoordinateSystem coord, boolean flipAxis, boolean horizontal) {
        List breaksDataAndLabel = CollectionsKt.zip((Iterable)scaleBreaks.getTransformedValues(), (Iterable)scaleBreaks.getLabels());
        ArrayList<Double> axisBreaks = new ArrayList<Double>();
        ArrayList<String> axisLabels = new ArrayList<String>();
        for (Pair pair : breaksDataAndLabel) {
            DoubleVector doubleVector;
            double br = ((Number)pair.component1()).doubleValue();
            String label = (String)pair.component2();
            boolean bl = horizontal;
            if (bl) {
                doubleVector = new DoubleVector(br, 0.0);
            } else if (!bl) {
                doubleVector = new DoubleVector(0.0, br);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleVector it = doubleVector;
            boolean bl2 = false;
            DoubleVector bpCoord = flipAxis ? it.flip() : it;
            DoubleVector bpClientCoord = coord.toClient(bpCoord);
            if (bpClientCoord == null || !bpClientCoord.isFinite()) continue;
            double bpOnAxis = horizontal ? bpClientCoord.getX() : bpClientCoord.getY();
            axisBreaks.add(bpOnAxis);
            axisLabels.add(label);
        }
        return new Pair(axisBreaks, axisLabels);
    }
}

