/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.PointPriorityReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.TimeRange;

public abstract class SeriesCompactionExecutor {
    protected final FastCompactionTaskSummary summary;
    protected List<FileElement> fileList = new ArrayList<FileElement>();
    protected final PriorityQueue<ChunkMetadataElement> chunkMetadataQueue;
    protected final PriorityQueue<PageElement> pageQueue;
    protected AbstractCompactionWriter compactionWriter;
    protected int subTaskId;
    protected Map<TsFileResource, TsFileSequenceReader> readerCacheMap;
    protected final Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap;
    protected final PointPriorityReader pointPriorityReader;
    protected IDeviceID deviceId;
    protected boolean isBatchedCompaction = false;
    private final List<PageElement> candidateOverlappedPages = new ArrayList<PageElement>();
    private long nextChunkStartTime = Long.MAX_VALUE;
    private long nextPageStartTime = Long.MAX_VALUE;
    protected boolean isAligned;

    protected SeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, IDeviceID deviceId, boolean isAligned, int subTaskId, FastCompactionTaskSummary summary) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = subTaskId;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.summary = summary;
        this.pointPriorityReader = new PointPriorityReader(this::checkShouldRemoveFile, isAligned);
        this.isAligned = isAligned;
        this.chunkMetadataQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.startTime, o2.startTime);
            return timeCompare != 0 ? timeCompare : o2.getPriority().compareTo(o1.getPriority());
        });
        this.pageQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.getStartTime(), o2.getStartTime());
            return timeCompare != 0 ? timeCompare : o2.getPriority().compareTo(o1.getPriority());
        });
    }

    public abstract void execute() throws PageException, IllegalPathException, IOException, WriteProcessException;

    protected abstract void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException;

    protected void compactChunks() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.chunkMetadataQueue.isEmpty()) {
            ChunkMetadataElement firstChunkMetadataElement = this.chunkMetadataQueue.poll();
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
            boolean isChunkOverlap = firstChunkMetadataElement.chunkMetadata.getEndTime() >= this.nextChunkStartTime;
            boolean isModified = firstChunkMetadataElement.chunkMetadata.isModified();
            this.readChunk(firstChunkMetadataElement);
            if (isChunkOverlap || isModified) {
                ++this.summary.chunkOverlapOrModified;
                this.compactWithOverlapChunks(firstChunkMetadataElement);
                continue;
            }
            ++this.summary.chunkNoneOverlap;
            this.compactWithNonOverlapChunk(firstChunkMetadataElement);
        }
    }

    private void compactWithOverlapChunks(ChunkMetadataElement overlappedChunkMetadata) throws IOException, PageException, WriteProcessException, IllegalPathException {
        this.deserializeChunkIntoPageQueue(overlappedChunkMetadata);
        this.compactPages();
    }

    private void compactWithNonOverlapChunk(ChunkMetadataElement chunkMetadataElement) throws IOException, PageException, WriteProcessException, IllegalPathException {
        boolean success = this.flushChunkToCompactionWriter(chunkMetadataElement);
        if (success) {
            this.updateSummary(chunkMetadataElement, ChunkStatus.DIRECTORY_FLUSH);
            this.checkShouldRemoveFile(chunkMetadataElement);
        } else {
            ++this.summary.chunkNoneOverlapButDeserialize;
            this.deserializeChunkIntoPageQueue(chunkMetadataElement);
            this.compactPages();
        }
    }

    protected abstract boolean flushChunkToCompactionWriter(ChunkMetadataElement var1) throws IOException;

    protected abstract void deserializeChunkIntoPageQueue(ChunkMetadataElement var1) throws IOException;

    abstract void readChunk(ChunkMetadataElement var1) throws IOException;

    abstract void deserializeFileIntoChunkMetadataQueue(List<FileElement> var1) throws IOException, IllegalPathException;

    private void compactPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.pageQueue.isEmpty()) {
            boolean isPageOverlap;
            PageElement firstPageElement = this.getPageFromPageQueue(this.pageQueue.peek().getStartTime());
            ModifiedStatus modifiedStatus = this.isPageModified(firstPageElement);
            if (modifiedStatus == ModifiedStatus.ALL_DELETED) {
                this.checkShouldRemoveFile(firstPageElement);
                continue;
            }
            boolean bl = isPageOverlap = firstPageElement.getEndTime() >= this.nextPageStartTime || firstPageElement.getEndTime() >= this.nextChunkStartTime;
            if (isPageOverlap || modifiedStatus == ModifiedStatus.PARTIAL_DELETED || firstPageElement.needForceDecoding()) {
                ++this.summary.pageOverlapOrModified;
                if (!this.pointPriorityReader.addNewPageIfPageNotEmpty(firstPageElement)) continue;
                this.compactWithOverlapPages();
                continue;
            }
            ++this.summary.pageNoneOverlap;
            this.compactWithNonOverlapPage(firstPageElement);
        }
    }

    private void compactWithNonOverlapPage(PageElement pageElement) throws PageException, IOException, WriteProcessException, IllegalPathException {
        boolean success = this.flushPageToCompactionWriter(pageElement);
        if (success) {
            this.checkShouldRemoveFile(pageElement);
        } else {
            TimeValuePair point;
            ++this.summary.pageNoneOverlapButDeserialize;
            if (!this.pointPriorityReader.addNewPageIfPageNotEmpty(pageElement)) {
                return;
            }
            while (this.pointPriorityReader.hasNext() && (point = this.pointPriorityReader.currentPoint()).getTimestamp() <= pageElement.getEndTime()) {
                this.compactionWriter.write(point, this.subTaskId);
                this.pointPriorityReader.next();
            }
        }
    }

    protected abstract boolean flushPageToCompactionWriter(PageElement var1) throws PageException, IOException;

    private void compactWithOverlapPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (this.pointPriorityReader.hasNext()) {
            TimeValuePair currentPoint = this.pointPriorityReader.currentPoint();
            long currentTime = currentPoint.getTimestamp();
            while (currentTime >= this.nextChunkStartTime || currentTime >= this.nextPageStartTime) {
                PageElement nextPageElement = this.getPageFromPageQueue(currentTime);
                this.checkAndCompactOverlapPage(nextPageElement, currentPoint);
                currentPoint = this.pointPriorityReader.currentPoint();
                currentTime = currentPoint.getTimestamp();
            }
            this.compactionWriter.write(currentPoint, this.subTaskId);
            this.pointPriorityReader.next();
        }
    }

    private void checkAndCompactOverlapPage(PageElement nextPageElement, TimeValuePair currentPoint) throws IOException, IllegalPathException, PageException, WriteProcessException {
        ModifiedStatus nextPageModifiedStatus = this.isPageModified(nextPageElement);
        if (nextPageModifiedStatus == ModifiedStatus.ALL_DELETED) {
            this.checkShouldRemoveFile(nextPageElement);
        } else {
            boolean isNextPageOverlap;
            boolean bl = isNextPageOverlap = currentPoint.getTimestamp() <= nextPageElement.getEndTime() || nextPageElement.getEndTime() >= this.nextPageStartTime || nextPageElement.getEndTime() >= this.nextChunkStartTime;
            if (isNextPageOverlap || nextPageModifiedStatus == ModifiedStatus.PARTIAL_DELETED || nextPageElement.needForceDecoding()) {
                ++this.summary.pageOverlapOrModified;
                this.pointPriorityReader.addNewPageIfPageNotEmpty(nextPageElement);
            } else {
                ++this.summary.pageFakeOverlap;
                this.compactWithNonOverlapPage(nextPageElement);
            }
        }
    }

    protected List<FileElement> findOverlapFiles(FileElement fileToCheck) {
        ArrayList<FileElement> overlappedFiles = new ArrayList<FileElement>();
        Optional<Long> endTimeInCheckingFile = fileToCheck.resource.getEndTime(this.deviceId);
        for (FileElement otherFile : this.fileList) {
            if (!endTimeInCheckingFile.isPresent()) continue;
            Optional<Long> startTimeInOtherFile = otherFile.resource.getStartTime(this.deviceId);
            if (!startTimeInOtherFile.isPresent() || startTimeInOtherFile.get() > endTimeInCheckingFile.get()) break;
            if (otherFile.isSelected) continue;
            overlappedFiles.add(otherFile);
            otherFile.isSelected = true;
        }
        return overlappedFiles;
    }

    protected abstract ModifiedStatus isPageModified(PageElement var1);

    protected ModifiedStatus checkIsModified(long startTime, long endTime, Collection<TimeRange> deletions) {
        ModifiedStatus status = ModifiedStatus.NONE_DELETED;
        if (deletions != null) {
            for (TimeRange range : deletions) {
                if (range.contains(startTime, endTime)) {
                    return ModifiedStatus.ALL_DELETED;
                }
                if (!range.overlaps(new TimeRange(startTime, endTime))) continue;
                status = ModifiedStatus.PARTIAL_DELETED;
            }
        }
        return status;
    }

    private PageElement getPageFromPageQueue(long curTime) throws IOException {
        if (curTime >= this.nextChunkStartTime) {
            ++this.summary.chunkOverlapOrModified;
            ChunkMetadataElement chunkMetadataElement = this.chunkMetadataQueue.poll();
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
            this.readChunk(chunkMetadataElement);
            this.deserializeChunkIntoPageQueue(chunkMetadataElement);
        }
        PageElement page = this.pageQueue.poll();
        this.nextPageStartTime = this.pageQueue.isEmpty() ? Long.MAX_VALUE : this.pageQueue.peek().getStartTime();
        return page;
    }

    protected void checkShouldRemoveFile(PageElement pageElement) throws IOException, IllegalPathException {
        if (pageElement.isLastPage() && pageElement.getChunkMetadataElement().isLastChunk) {
            this.removeFile(pageElement.getChunkMetadataElement().fileElement);
        }
    }

    protected void checkShouldRemoveFile(ChunkMetadataElement chunkMetadataElement) throws IOException, IllegalPathException {
        if (chunkMetadataElement.isLastChunk) {
            this.removeFile(chunkMetadataElement.fileElement);
        }
    }

    protected void removeFile(FileElement fileElement) throws IllegalPathException, IOException {
        boolean isFirstFile = this.fileList.get(0).equals(fileElement);
        this.fileList.remove(fileElement);
        if (isFirstFile && !this.fileList.isEmpty()) {
            List<FileElement> newOverlappedFiles = this.findOverlapFiles(this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(newOverlappedFiles);
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
        }
    }

    protected List<ModEntry> getModificationsFromCache(TsFileResource tsFileResource, PartialPath path) {
        PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer> allModifications = this.modificationCacheMap.get(tsFileResource.getTsFile().getName());
        if (allModifications == null) {
            return Collections.emptyList();
        }
        List modEntries = allModifications.getOverlapped(path);
        if (path.getIDeviceID().isTableModel()) {
            modEntries = modEntries.stream().filter(e -> e.affects(path.getIDeviceID()) && e.affects(path.getMeasurement())).collect(Collectors.toList());
        }
        return ModificationUtils.sortAndMerge(modEntries);
    }

    protected void updateSummary(ChunkMetadataElement chunkMetadataElement, ChunkStatus status) {
        switch (status) {
            case READ_IN: {
                this.summary.increaseProcessChunkNum(this.isAligned ? ((AbstractAlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1 : 1);
                if (this.isAligned) {
                    for (IChunkMetadata valueChunkMetadata : ((AbstractAlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList()) {
                        if (valueChunkMetadata == null) continue;
                        this.summary.increaseProcessPointNum(valueChunkMetadata.getStatistics().getCount());
                    }
                    break;
                }
                this.summary.increaseProcessPointNum(chunkMetadataElement.chunkMetadata.getStatistics().getCount());
                break;
            }
            case DIRECTORY_FLUSH: {
                if (this.isAligned) {
                    this.summary.increaseDirectlyFlushChunkNum(((AbstractAlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1);
                    break;
                }
                this.summary.increaseDirectlyFlushChunkNum(1);
                break;
            }
            case DESERIALIZE_CHUNK: {
                if (this.isAligned) {
                    this.summary.increaseDeserializedChunkNum(((AbstractAlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1);
                    break;
                }
                this.summary.increaseDeserializedChunkNum(1);
                break;
            }
        }
    }

    @FunctionalInterface
    public static interface RemovePage {
        public void call(PageElement var1) throws WriteProcessException, IOException, IllegalPathException;
    }

    protected static enum ChunkStatus {
        READ_IN,
        DIRECTORY_FLUSH,
        DESERIALIZE_CHUNK;

    }
}

