/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcda;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.pipe.connector.protocol.opcda.OpcDaHeader;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTreeModelTabletEventSorter;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcDaServerHandle
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcDaServerHandle.class);
    private final OpcDaHeader.IOPCServer opcServer;
    private final OpcDaHeader.IOPCItemMgt itemMgt;
    private final OpcDaHeader.IOPCSyncIO syncIO;
    private final Map<String, Integer> serverHandleMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Long> serverTimestampMap = new ConcurrentHashMap<String, Long>();
    private WTypes.BSTR bstr;

    OpcDaServerHandle(String clsOrProgID) {
        Guid.CLSID CLSID_OPC_SERVER = new Guid.CLSID(clsOrProgID);
        Ole32.INSTANCE.CoInitializeEx(null, 0);
        PointerByReference ppvServer = new PointerByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance((Guid.GUID)CLSID_OPC_SERVER, null, 23, (Guid.GUID)OpcDaHeader.IID_IOPCServer, ppvServer);
        if (hr.intValue() != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to connect to server, error code: 0x" + Integer.toHexString(hr.intValue()));
        }
        this.opcServer = new OpcDaHeader.IOPCServer(ppvServer.getValue());
        PointerByReference phServerGroup = new PointerByReference();
        PointerByReference phOPCGroup = new PointerByReference();
        IntByReference pRevisedUpdateRate = new IntByReference();
        int hr2 = this.opcServer.addGroup("", true, 1000, 0, null, null, 0, phServerGroup, pRevisedUpdateRate, new Guid.GUID.ByReference(OpcDaHeader.IID_IUNKNOWN.getPointer()), phOPCGroup);
        if (hr2 != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to create group\uff0cerror code: 0x" + Integer.toHexString(hr.intValue()));
        }
        LOGGER.info("Create group successfully! Server handle: {}, update rate: {} ms", (Object)phServerGroup.getValue(), (Object)pRevisedUpdateRate.getValue());
        Unknown groupUnknown = new Unknown(phOPCGroup.getValue());
        PointerByReference ppvItemMgt = new PointerByReference();
        hr = groupUnknown.QueryInterface(new Guid.REFIID(new Guid.GUID.ByReference((Guid.GUID)OpcDaHeader.IID_IOPCItemMgt).getPointer()), ppvItemMgt);
        if (hr.intValue() != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to acquire IOPCItemMgt, error code: 0x" + Integer.toHexString(hr.intValue()));
        }
        LOGGER.info("Acquire IOPCItemMgt successfully! Interface address: {}", (Object)ppvItemMgt.getValue());
        this.itemMgt = new OpcDaHeader.IOPCItemMgt(ppvItemMgt.getValue());
        PointerByReference ppvSyncIO = new PointerByReference();
        hr = groupUnknown.QueryInterface(new Guid.REFIID(new Guid.GUID.ByReference((Guid.GUID)OpcDaHeader.IID_IOPCSyncIO).getPointer()), ppvSyncIO);
        if (hr.intValue() != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to acquire IOPCSyncIO, error code: 0x" + Integer.toHexString(hr.intValue()));
        }
        LOGGER.info("Acquire IOPCSyncIO successfully! Interface address: {}", (Object)ppvSyncIO.getValue());
        this.syncIO = new OpcDaHeader.IOPCSyncIO(ppvSyncIO.getValue());
    }

    static String getClsIDFromProgID(String progID) {
        Guid.CLSID.ByReference pclsid = new Guid.CLSID.ByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CLSIDFromProgID(progID, pclsid);
        if (hr.intValue() == WinError.S_OK.intValue()) {
            String clsidStr = String.format("%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X", pclsid.Data1, pclsid.Data2, pclsid.Data3, pclsid.Data4[0], pclsid.Data4[1], pclsid.Data4[2], pclsid.Data4[3], pclsid.Data4[4], pclsid.Data4[5], pclsid.Data4[6], pclsid.Data4[7]);
            LOGGER.info("Successfully converted progID {} to CLSID: {{}}", (Object)progID, (Object)clsidStr);
            return clsidStr;
        }
        throw new PipeException("Error: ProgID is invalid or unregistered, (HRESULT=0x" + Integer.toHexString(hr.intValue()) + ")");
    }

    void transfer(Tablet tablet) {
        new PipeTreeModelTabletEventSorter(tablet).deduplicateAndSortTimestampsIfNecessary();
        List schemas = tablet.getSchemas();
        block0: for (int i = 0; i < schemas.size(); ++i) {
            String itemId = tablet.getDeviceId() + "." + ((IMeasurementSchema)schemas.get(i)).getMeasurementName();
            if (!this.serverHandleMap.containsKey(itemId)) {
                this.addItem(itemId, ((IMeasurementSchema)schemas.get(i)).getType());
            }
            for (int j = tablet.getRowSize() - 1; j >= 0; --j) {
                if (tablet.isNull(j, i)) continue;
                if (this.serverTimestampMap.get(itemId) > tablet.getTimestamp(j)) continue block0;
                this.writeData(itemId, this.getTabletObjectValue4Opc(tablet.getValues()[i], j, ((IMeasurementSchema)schemas.get(i)).getType()));
                this.serverTimestampMap.put(itemId, tablet.getTimestamp(j));
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(String itemId, TSDataType type) {
        int hr;
        PointerByReference ppItemResults;
        block6: {
            OpcDaHeader.OPCITEMDEF[] itemDefs = new OpcDaHeader.OPCITEMDEF[]{new OpcDaHeader.OPCITEMDEF()};
            itemDefs[0].szAccessPath = new WString("");
            itemDefs[0].szItemID = new WString(itemId + "\u0000");
            itemDefs[0].bActive = 1;
            itemDefs[0].hClient = 0;
            itemDefs[0].dwBlobSize = 0;
            itemDefs[0].pBlob = Pointer.NULL;
            itemDefs[0].vtRequestedDataType = this.convertTsDataType2VariantType(type);
            itemDefs[0].wReserved = 0;
            itemDefs[0].write();
            ppItemResults = new PointerByReference();
            PointerByReference ppErrors = new PointerByReference();
            hr = this.itemMgt.addItems(1, itemDefs, ppItemResults, ppErrors);
            Pointer pErrors = ppErrors.getValue();
            if (Objects.nonNull(pErrors)) {
                int[] errors = pErrors.getIntArray(0L, 1);
                int itemError = errors[0];
                try {
                    if (itemError == WinError.S_OK.intValue()) {
                        LOGGER.debug("Successfully added item {}.", (Object)itemId);
                        break block6;
                    }
                    throw new PipeException("Failed to add item " + itemId + ", opc error code: 0x" + Integer.toHexString(itemError));
                }
                finally {
                    Ole32.INSTANCE.CoTaskMemFree(pErrors);
                }
            }
        }
        if (hr != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to add item, win error code: 0x" + Integer.toHexString(hr));
        }
        Pointer pItemResults = ppItemResults.getValue();
        OpcDaHeader.OPCITEMRESULT[] itemResults = new OpcDaHeader.OPCITEMRESULT[]{new OpcDaHeader.OPCITEMRESULT(pItemResults)};
        itemResults[0].read();
        this.serverHandleMap.put(itemId, itemResults[0].hServer);
        this.serverTimestampMap.put(itemId, Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(String itemId, Variant.VARIANT value) {
        Pointer pErrors;
        Memory phServer = new Memory((long)Native.getNativeSize(Integer.TYPE));
        phServer.write(0L, new int[]{this.serverHandleMap.get(itemId)}, 0, 1);
        PointerByReference ppErrors = new PointerByReference();
        int hr = this.syncIO.write(1, (Pointer)phServer, value.getPointer(), ppErrors);
        if (Objects.nonNull(this.bstr)) {
            OleAuto.INSTANCE.SysFreeString(this.bstr);
            this.bstr = null;
        }
        if (Objects.nonNull(pErrors = ppErrors.getValue())) {
            int[] errors = pErrors.getIntArray(0L, 1);
            int itemError = errors[0];
            try {
                if (itemError != WinError.S_OK.intValue()) {
                    throw new PipeException("Failed to write " + itemId + ", value: " + value + ", opc error code: 0x" + Integer.toHexString(itemError));
                }
            }
            finally {
                Ole32.INSTANCE.CoTaskMemFree(pErrors);
            }
        }
        if (hr != WinError.S_OK.intValue()) {
            throw new PipeException("Failed to write, win error code: 0x" + Integer.toHexString(hr));
        }
    }

    private short convertTsDataType2VariantType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return 11;
            }
            case INT32: {
                return 3;
            }
            case INT64: {
                return 20;
            }
            case DATE: 
            case TIMESTAMP: {
                return 7;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return 8;
            }
        }
        throw new UnSupportedDataTypeException("UnSupported dataType " + dataType);
    }

    private Variant.VARIANT getTabletObjectValue4Opc(Object column, int rowIndex, TSDataType type) {
        Variant.VARIANT value = new Variant.VARIANT();
        switch (type) {
            case BOOLEAN: {
                value.setValue(11, (Object)new OaIdl.VARIANT_BOOL(((boolean[])column)[rowIndex]));
                break;
            }
            case INT32: {
                value.setValue(3, (Object)new WinDef.LONG((long)((int[])column)[rowIndex]));
                break;
            }
            case DATE: {
                value.setValue(7, (Object)new OaIdl.DATE((java.util.Date)Date.valueOf(((LocalDate[])column)[rowIndex])));
                break;
            }
            case INT64: {
                value.setValue(20, (Object)new WinDef.LONGLONG(((long[])column)[rowIndex]));
                break;
            }
            case TIMESTAMP: {
                value.setValue(7, (Object)new OaIdl.DATE(new java.util.Date(((long[])column)[rowIndex])));
                break;
            }
            case FLOAT: {
                value.setValue(4, (Object)Float.valueOf(((float[])column)[rowIndex]));
                break;
            }
            case DOUBLE: {
                value.setValue(5, (Object)((double[])column)[rowIndex]);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.bstr = OleAuto.INSTANCE.SysAllocString(((Binary[])column)[rowIndex].toString());
                value.setValue(8, (Object)this.bstr);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported dataType " + type);
            }
        }
        return value;
    }

    @Override
    public void close() {
        this.serverTimestampMap.clear();
        this.serverHandleMap.clear();
        if (Objects.nonNull((Object)this.syncIO)) {
            this.syncIO.Release();
        }
        if (Objects.nonNull((Object)this.itemMgt)) {
            this.itemMgt.Release();
        }
        if (Objects.nonNull((Object)this.opcServer)) {
            this.opcServer.Release();
        }
        Ole32.INSTANCE.CoUninitialize();
    }
}

