/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.tsfile.read.common.block.column.ColumnEncoderFactory;
import org.apache.tsfile.read.common.block.column.DictionaryColumn;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DictionaryColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(ColumnEncoding.deserializeFrom((ByteBuffer)input));
        Column dictionary = columnEncoder.readColumn(input, dataType, ReadWriteIOUtils.readInt(input));
        int[] ids = ReadWriteIOUtils.readInts(input);
        return dictionary.copyPositions(ids, 0, positionCount);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        DictionaryColumn dictionaryColumn = (DictionaryColumn)column;
        dictionaryColumn = dictionaryColumn.compact();
        Column dictionary = dictionaryColumn.getDictionary();
        dictionary.getEncoding().serializeTo(output);
        int positionCount = dictionary.getPositionCount();
        ReadWriteIOUtils.write(positionCount, (OutputStream)output);
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(dictionary.getEncoding());
        columnEncoder.writeColumn(output, dictionary);
        ReadWriteIOUtils.writeInts(dictionaryColumn.getRawIds(), dictionaryColumn.getRawIdsOffset(), dictionaryColumn.getPositionCount(), output);
    }
}

