/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.controller.IChunkMetadataLoader;

public abstract class AbstractAlignedTimeSeriesMetadata
implements ITimeSeriesMetadata {
    protected final TimeseriesMetadata timeseriesMetadata;
    protected final List<TimeseriesMetadata> valueTimeseriesMetadataList;
    protected IChunkMetadataLoader chunkMetadataLoader;

    AbstractAlignedTimeSeriesMetadata(TimeseriesMetadata timeseriesMetadata, List<TimeseriesMetadata> valueTimeseriesMetadataList) {
        this.timeseriesMetadata = timeseriesMetadata;
        this.valueTimeseriesMetadataList = valueTimeseriesMetadataList;
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.timeseriesMetadata.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        TimeseriesMetadata metadata = this.valueTimeseriesMetadataList.get(measurementIndex);
        return Optional.ofNullable(metadata == null ? null : metadata.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        long rowCount = this.getTimeStatistics().getCount();
        Optional<Statistics<? extends Serializable>> statistics = this.getMeasurementStatistics(measurementIndex);
        return statistics.map(stat -> stat.hasNullValue(rowCount)).orElse(true);
    }

    @Override
    public int getMeasurementCount() {
        return this.valueTimeseriesMetadataList.size();
    }

    @Override
    public boolean isModified() {
        return this.timeseriesMetadata.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.timeseriesMetadata.setModified(modified);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setModified(modified);
        }
    }

    @Override
    public boolean isSeq() {
        return this.timeseriesMetadata.isSeq();
    }

    @Override
    public void setSeq(boolean seq) {
        this.timeseriesMetadata.setSeq(seq);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setSeq(seq);
        }
    }

    @Override
    public List<IChunkMetadata> loadChunkMetadataList() {
        return this.chunkMetadataLoader.loadChunkMetadataList(this);
    }

    public List<AbstractAlignedChunkMetadata> getCopiedChunkMetadataList() {
        List<IChunkMetadata> timeChunkMetadata = this.timeseriesMetadata.getCopiedChunkMetadataList();
        ArrayList<List<IChunkMetadata>> valueChunkMetadataList = new ArrayList<List<IChunkMetadata>>();
        for (TimeseriesMetadata metadata : this.valueTimeseriesMetadataList) {
            valueChunkMetadataList.add(metadata == null ? null : metadata.getCopiedChunkMetadataList());
        }
        return this.getAlignedChunkMetadata(timeChunkMetadata, valueChunkMetadataList);
    }

    public List<AbstractAlignedChunkMetadata> getChunkMetadataList() {
        List<IChunkMetadata> timeChunkMetadata = this.timeseriesMetadata.getChunkMetadataList();
        ArrayList<List<IChunkMetadata>> valueChunkMetadataList = new ArrayList<List<IChunkMetadata>>();
        for (TimeseriesMetadata metadata : this.valueTimeseriesMetadataList) {
            valueChunkMetadataList.add(metadata == null ? null : metadata.getChunkMetadataList());
        }
        return this.getAlignedChunkMetadata(timeChunkMetadata, valueChunkMetadataList);
    }

    private List<AbstractAlignedChunkMetadata> getAlignedChunkMetadata(List<IChunkMetadata> timeChunkMetadata, List<List<IChunkMetadata>> valueChunkMetadataList) {
        ArrayList<AbstractAlignedChunkMetadata> res = new ArrayList<AbstractAlignedChunkMetadata>();
        for (int i = 0; i < timeChunkMetadata.size(); ++i) {
            if (this.valueTimeseriesMetadataList.isEmpty()) {
                res.add(new AlignedChunkMetadata(timeChunkMetadata.get(i), Collections.emptyList()));
                continue;
            }
            ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List<IChunkMetadata> chunkMetadata : valueChunkMetadataList) {
                IChunkMetadata v = chunkMetadata == null || chunkMetadata.get(i).getStatistics().getCount() == 0 ? null : chunkMetadata.get(i);
                exits = exits || v != null;
                chunkMetadataList.add(v);
            }
            this.constructAlignedChunkMetadata(res, timeChunkMetadata.get(i), chunkMetadataList, exits);
        }
        return res;
    }

    abstract void constructAlignedChunkMetadata(List<AbstractAlignedChunkMetadata> var1, IChunkMetadata var2, List<IChunkMetadata> var3, boolean var4);

    abstract AbstractAlignedChunkMetadata constructOnlyTimeChunkMetadata(IChunkMetadata var1);

    @Override
    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    @Override
    public boolean typeMatch(List<TSDataType> dataTypes) {
        if (dataTypes.isEmpty()) {
            return true;
        }
        if (this.valueTimeseriesMetadataList != null) {
            int notMatchCount = 0;
            int size = dataTypes.size();
            for (int i = 0; i < size; ++i) {
                TimeseriesMetadata valueTimeSeriesMetadata = this.valueTimeseriesMetadataList.get(i);
                if (valueTimeSeriesMetadata == null || valueTimeSeriesMetadata.typeMatch(dataTypes.get(i))) continue;
                this.valueTimeseriesMetadataList.set(i, null);
                ++notMatchCount;
            }
            return notMatchCount != dataTypes.size();
        }
        return true;
    }

    public List<TimeseriesMetadata> getValueTimeseriesMetadataList() {
        return this.valueTimeseriesMetadataList;
    }

    public TimeseriesMetadata getTimeseriesMetadata() {
        return this.timeseriesMetadata;
    }
}

