/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.RowType;
import org.apache.tsfile.read.common.type.Type;

public enum TableBuiltinAggregationFunction {
    SUM("sum"),
    COUNT("count"),
    COUNT_ALL("count_all"),
    COUNT_IF("count_if"),
    AVG("avg"),
    EXTREME("extreme"),
    MAX("max"),
    MIN("min"),
    FIRST("first"),
    FIRST_BY("first_by"),
    LAST("last"),
    LAST_BY("last_by"),
    MODE("mode"),
    MAX_BY("max_by"),
    MIN_BY("min_by"),
    STDDEV("stddev"),
    STDDEV_POP("stddev_pop"),
    STDDEV_SAMP("stddev_samp"),
    VARIANCE("variance"),
    VAR_POP("var_pop"),
    VAR_SAMP("var_samp");

    private final String functionName;
    private static final Set<String> BUILT_IN_AGGREGATE_FUNCTION_NAME;

    private TableBuiltinAggregationFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getBuiltInAggregateFunctionName() {
        return BUILT_IN_AGGREGATE_FUNCTION_NAME;
    }

    public static Type getIntermediateType(String name, List<Type> originalArgumentTypes) {
        String functionName;
        switch (functionName = name.toLowerCase()) {
            case "count": 
            case "count_all": 
            case "count_if": {
                return LongType.INT64;
            }
            case "sum": {
                return DoubleType.DOUBLE;
            }
            case "avg": 
            case "first": 
            case "first_by": 
            case "last": 
            case "last_by": 
            case "mode": 
            case "max_by": 
            case "min_by": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return RowType.anonymous(Collections.emptyList());
            }
            case "extreme": 
            case "max": 
            case "min": {
                return originalArgumentTypes.get(0);
            }
        }
        return BlobType.BLOB;
    }

    public static TAggregationType getAggregationTypeByFuncName(String funcName) {
        if (BUILT_IN_AGGREGATE_FUNCTION_NAME.contains(funcName)) {
            return TAggregationType.valueOf((String)funcName.toUpperCase());
        }
        return TAggregationType.UDAF;
    }

    static {
        BUILT_IN_AGGREGATE_FUNCTION_NAME = new HashSet<String>(Arrays.stream(TableBuiltinAggregationFunction.values()).map(TableBuiltinAggregationFunction::getFunctionName).collect(Collectors.toList()));
    }
}

