/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;

public class WriteFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private SubPlan subPlan;
    private IAnalysis analysis;
    private MPPQueryContext queryContext;
    private BiFunction<WritePlanNode, IAnalysis, List<WritePlanNode>> nodeSplitter;

    public WriteFragmentParallelPlanner(SubPlan subPlan, IAnalysis analysis, MPPQueryContext queryContext) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = queryContext;
        this.nodeSplitter = WritePlanNode::splitByPartition;
    }

    public WriteFragmentParallelPlanner(SubPlan subPlan, IAnalysis analysis, MPPQueryContext queryContext, BiFunction<WritePlanNode, IAnalysis, List<WritePlanNode>> nodeSplitter) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = queryContext;
        this.nodeSplitter = nodeSplitter;
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        PlanFragment fragment = this.subPlan.getPlanFragment();
        PlanNode node = fragment.getPlanNodeTree();
        if (!(node instanceof WritePlanNode)) {
            throw new IllegalArgumentException("PlanNode should be IWritePlanNode in WRITE operation:" + node.getClass());
        }
        List<WritePlanNode> splits = this.nodeSplitter.apply((WritePlanNode)node, this.analysis);
        ArrayList<FragmentInstance> ret = new ArrayList<FragmentInstance>();
        for (WritePlanNode split : splits) {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(fragment.getId(), split), fragment.getId().genFragmentInstanceId(), this.analysis.getConvertedTimePredicate(), this.queryContext.getQueryType(), Long.MAX_VALUE, this.queryContext.getSession());
            if (split.getRegionReplicaSet() != null) {
                instance.setExecutorAndHost((ExecutorType)new StorageExecutor(split.getRegionReplicaSet()));
            }
            ret.add(instance);
        }
        return ret;
    }
}

