/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowDBTask
implements IConfigTask {
    private final ShowDB node;
    private final Predicate<String> canSeenDB;

    public ShowDBTask(ShowDB node, Predicate<String> canSeenDB) {
        this.node = node;
        this.canSeenDB = canSeenDB;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showDatabases(this.node, this.canSeenDB);
    }

    public static void buildTSBlock(Map<String, TDatabaseInfo> storageGroupInfoMap, SettableFuture<ConfigTaskResult> future, boolean isDetails, Predicate<String> canSeenDB) {
        if (isDetails) {
            ShowDBTask.buildTSBlockForDetails(storageGroupInfoMap, future, canSeenDB);
        } else {
            ShowDBTask.buildTSBlockForNonDetails(storageGroupInfoMap, future, canSeenDB);
        }
    }

    private static void buildTSBlockForNonDetails(Map<String, TDatabaseInfo> storageGroupInfoMap, SettableFuture<ConfigTaskResult> future, Predicate<String> canSeenDB) {
        List outputDataTypes = ColumnHeaderConstant.showDBColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        InformationSchemaUtils.buildDatabaseTsBlock(canSeenDB, builder, false, true);
        for (Map.Entry<String, TDatabaseInfo> entry : storageGroupInfoMap.entrySet()) {
            String dbName = entry.getKey();
            if (Boolean.FALSE.equals(canSeenDB.test(dbName))) continue;
            TDatabaseInfo storageGroupInfo = entry.getValue();
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(dbName, TSFileConfig.STRING_CHARSET));
            if (Long.MAX_VALUE == storageGroupInfo.getTTL()) {
                builder.getColumnBuilder(1).writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            } else {
                builder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(storageGroupInfo.getTTL()), TSFileConfig.STRING_CHARSET));
            }
            builder.getColumnBuilder(2).writeInt(storageGroupInfo.getSchemaReplicationFactor());
            builder.getColumnBuilder(3).writeInt(storageGroupInfo.getDataReplicationFactor());
            builder.getColumnBuilder(4).writeLong(storageGroupInfo.getTimePartitionInterval());
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowDBHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static void buildTSBlockForDetails(Map<String, TDatabaseInfo> storageGroupInfoMap, SettableFuture<ConfigTaskResult> future, Predicate<String> canSeenDB) {
        List outputDataTypes = ColumnHeaderConstant.showDBDetailsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        InformationSchemaUtils.buildDatabaseTsBlock(canSeenDB, builder, true, true);
        for (Map.Entry<String, TDatabaseInfo> entry : storageGroupInfoMap.entrySet()) {
            String dbName = entry.getKey();
            if (!canSeenDB.test(dbName)) continue;
            TDatabaseInfo storageGroupInfo = entry.getValue();
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(dbName, TSFileConfig.STRING_CHARSET));
            if (Long.MAX_VALUE == storageGroupInfo.getTTL()) {
                builder.getColumnBuilder(1).writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            } else {
                builder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(storageGroupInfo.getTTL()), TSFileConfig.STRING_CHARSET));
            }
            builder.getColumnBuilder(2).writeInt(storageGroupInfo.getSchemaReplicationFactor());
            builder.getColumnBuilder(3).writeInt(storageGroupInfo.getDataReplicationFactor());
            builder.getColumnBuilder(4).writeLong(storageGroupInfo.getTimePartitionInterval());
            builder.getColumnBuilder(5).writeInt(storageGroupInfo.getSchemaRegionNum());
            builder.getColumnBuilder(6).writeInt(storageGroupInfo.getDataRegionNum());
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowDBDetailsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

