/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AggregationMergeSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.PartitionRecognizer;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.PartitionState;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.Slice;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.SliceCache;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableFunctionOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AggregationMergeSortOperator.class);
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private final OperatorContext operatorContext;
    private final Operator inputOperator;
    private final TableFunctionProcessorProvider processorProvider;
    private final PartitionRecognizer partitionRecognizer;
    private final TsBlockBuilder blockBuilder;
    private final int properChannelCount;
    private final boolean needPassThrough;
    private final SliceCache sliceCache;
    private TableFunctionDataProcessor processor;
    private PartitionState partitionState;
    private ListenableFuture<?> isBlocked;
    private boolean finished = false;

    public TableFunctionOperator(OperatorContext operatorContext, TableFunctionProcessorProvider processorProvider, Operator inputOperator, List<TSDataType> inputDataTypes, List<TSDataType> outputDataTypes, int properChannelCount, List<Integer> requiredChannels, List<Integer> passThroughChannels, List<Integer> partitionChannels) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.properChannelCount = properChannelCount;
        this.processorProvider = processorProvider;
        this.partitionRecognizer = new PartitionRecognizer(partitionChannels, requiredChannels, passThroughChannels, inputDataTypes);
        this.needPassThrough = properChannelCount != outputDataTypes.size();
        this.partitionState = null;
        this.blockBuilder = new TsBlockBuilder(outputDataTypes);
        this.sliceCache = new SliceCache();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked == null) {
            this.isBlocked = this.tryGetNextTsBlock();
        }
        return this.isBlocked;
    }

    private ListenableFuture<?> tryGetNextTsBlock() {
        try {
            if (this.inputOperator.isFinished()) {
                this.partitionRecognizer.noMoreData();
                return NOT_BLOCKED;
            }
            if (!this.inputOperator.isBlocked().isDone()) {
                return this.inputOperator.isBlocked();
            }
            if (this.inputOperator.hasNextWithTimer()) {
                this.partitionRecognizer.addTsBlock(this.inputOperator.nextWithTimer());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.partitionState == null) {
            this.partitionState = this.partitionRecognizer.nextState();
        }
        PartitionState.StateType stateType = this.partitionState.getStateType();
        Slice slice = this.partitionState.getSlice();
        if (stateType == PartitionState.StateType.INIT || stateType == PartitionState.StateType.NEED_MORE_DATA) {
            this.consumeCurrentPartitionState();
            this.consumeCurrentSourceTsBlock();
            return null;
        }
        List<ColumnBuilder> properColumnBuilders = this.getProperColumnBuilders();
        ColumnBuilder passThroughIndexBuilder = this.getPassThroughIndexBuilder();
        if (stateType == PartitionState.StateType.FINISHED) {
            if (this.processor != null) {
                this.processor.finish(properColumnBuilders, passThroughIndexBuilder);
            }
            this.finished = true;
            TsBlock tsBlock = this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder);
            this.sliceCache.clear();
            this.consumeCurrentPartitionState();
            return tsBlock;
        }
        if (stateType == PartitionState.StateType.NEW_PARTITION) {
            if (this.processor != null) {
                this.processor.finish(properColumnBuilders, passThroughIndexBuilder);
                TsBlock tsBlock = this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder);
                this.sliceCache.clear();
                this.processor = null;
                return tsBlock;
            }
            this.processor = this.processorProvider.getDataProcessor();
            this.processor.beforeStart();
        }
        this.sliceCache.addSlice(slice);
        Iterator<Record> recordIterator = slice.getRequiredRecordIterator();
        while (recordIterator.hasNext()) {
            this.processor.process(recordIterator.next(), properColumnBuilders, passThroughIndexBuilder);
        }
        this.consumeCurrentPartitionState();
        return this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder);
    }

    private List<ColumnBuilder> getProperColumnBuilders() {
        this.blockBuilder.reset();
        return Arrays.asList(this.blockBuilder.getValueColumnBuilders()).subList(0, this.properChannelCount);
    }

    private ColumnBuilder getPassThroughIndexBuilder() {
        return new LongColumnBuilder(null, 1);
    }

    private TsBlock buildTsBlock(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
        List<ColumnBuilder> passThroughColumnBuilders = Arrays.asList(this.blockBuilder.getValueColumnBuilders()).subList(this.properChannelCount, this.blockBuilder.getValueColumnBuilders().length);
        int positionCount = 0;
        if (this.properChannelCount > 0) {
            positionCount = properColumnBuilders.get(0).getPositionCount();
        } else if (this.needPassThrough) {
            positionCount = passThroughIndexBuilder.getPositionCount();
        }
        if (positionCount == 0) {
            return null;
        }
        this.blockBuilder.declarePositions(positionCount);
        if (this.needPassThrough) {
            Column passThroughIndex = passThroughIndexBuilder.build();
            for (Column[] passThroughColumns : this.sliceCache.getPassThroughResult(passThroughIndex)) {
                for (int i = 0; i < passThroughColumns.length; ++i) {
                    ColumnBuilder passThroughColumnBuilder = passThroughColumnBuilders.get(i);
                    for (int j = 0; j < passThroughColumns[i].getPositionCount(); ++j) {
                        if (passThroughColumns[i].isNull(j)) {
                            passThroughColumnBuilder.appendNull();
                            continue;
                        }
                        passThroughColumnBuilder.write(passThroughColumns[i], j);
                    }
                }
            }
        }
        return this.blockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, positionCount));
    }

    private void consumeCurrentPartitionState() {
        this.partitionState = null;
    }

    private void consumeCurrentSourceTsBlock() {
        this.isBlocked = null;
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished;
    }

    @Override
    public void close() throws Exception {
        this.sliceCache.close();
        this.inputOperator.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.inputOperator.calculateMaxPeekMemory() + Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.blockBuilder.getRetainedSizeInBytes());
    }

    @Override
    public long calculateMaxReturnSize() {
        return Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.blockBuilder.getRetainedSizeInBytes());
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + this.blockBuilder.getRetainedSizeInBytes() + this.sliceCache.getEstimatedSize();
    }
}

