/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ReadValueId
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=626");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=628");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=627");
    private final NodeId nodeId;
    private final UInteger attributeId;
    private final String indexRange;
    private final QualifiedName dataEncoding;

    public ReadValueId(NodeId nodeId, UInteger attributeId, String indexRange, QualifiedName dataEncoding) {
        this.nodeId = nodeId;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
        this.dataEncoding = dataEncoding;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    protected ReadValueId(ReadValueIdBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((ReadValueIdBuilder)b).nodeId;
        this.attributeId = ((ReadValueIdBuilder)b).attributeId;
        this.indexRange = ((ReadValueIdBuilder)b).indexRange;
        this.dataEncoding = ((ReadValueIdBuilder)b).dataEncoding;
    }

    public static ReadValueIdBuilder<?, ?> builder() {
        return new ReadValueIdBuilderImpl();
    }

    public ReadValueIdBuilder<?, ?> toBuilder() {
        return new ReadValueIdBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadValueId)) {
            return false;
        }
        ReadValueId other = (ReadValueId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        UInteger this$attributeId = this.getAttributeId();
        UInteger other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        if (this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange)) {
            return false;
        }
        QualifiedName this$dataEncoding = this.getDataEncoding();
        QualifiedName other$dataEncoding = other.getDataEncoding();
        return !(this$dataEncoding == null ? other$dataEncoding != null : !((Object)this$dataEncoding).equals(other$dataEncoding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReadValueId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        UInteger $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        QualifiedName $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : ((Object)$dataEncoding).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadValueId(nodeId=" + this.getNodeId() + ", attributeId=" + this.getAttributeId() + ", indexRange=" + this.getIndexRange() + ", dataEncoding=" + this.getDataEncoding() + ")";
    }

    private static final class ReadValueIdBuilderImpl
    extends ReadValueIdBuilder<ReadValueId, ReadValueIdBuilderImpl> {
        private ReadValueIdBuilderImpl() {
        }

        @Override
        protected ReadValueIdBuilderImpl self() {
            return this;
        }

        @Override
        public ReadValueId build() {
            return new ReadValueId(this);
        }
    }

    public static abstract class ReadValueIdBuilder<C extends ReadValueId, B extends ReadValueIdBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private UInteger attributeId;
        private String indexRange;
        private QualifiedName dataEncoding;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadValueIdBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadValueId instance, ReadValueIdBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.attributeId(instance.attributeId);
            b.indexRange(instance.indexRange);
            b.dataEncoding(instance.dataEncoding);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B attributeId(UInteger attributeId) {
            this.attributeId = attributeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        public B dataEncoding(QualifiedName dataEncoding) {
            this.dataEncoding = dataEncoding;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadValueId.ReadValueIdBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", attributeId=" + this.attributeId + ", indexRange=" + this.indexRange + ", dataEncoding=" + this.dataEncoding + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadValueId> {
        @Override
        public Class<ReadValueId> getType() {
            return ReadValueId.class;
        }

        @Override
        public ReadValueId decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            QualifiedName dataEncoding = decoder.readQualifiedName("DataEncoding");
            return new ReadValueId(nodeId, attributeId, indexRange, dataEncoding);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadValueId value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeUInt32("AttributeId", value.getAttributeId());
            encoder.writeString("IndexRange", value.getIndexRange());
            encoder.writeQualifiedName("DataEncoding", value.getDataEncoding());
        }
    }
}

