/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.StringContainer;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchemaType;

public class VectorMeasurementSchema
implements IMeasurementSchema,
Comparable<VectorMeasurementSchema>,
Serializable {
    private String deviceId;
    private Map<String, Integer> measurementsToIndexMap;
    private byte[] types;
    private byte[] encodings;
    private TSEncodingBuilder[] encodingConverters;
    private byte compressor;

    public VectorMeasurementSchema() {
    }

    public VectorMeasurementSchema(String deviceId, String[] subMeasurements, TSDataType[] types, TSEncoding[] encodings, CompressionType compressionType) {
        this.deviceId = deviceId;
        this.measurementsToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < subMeasurements.length; ++i) {
            this.measurementsToIndexMap.put(subMeasurements[i], i);
        }
        byte[] typesInByte = new byte[types.length];
        for (int i = 0; i < types.length; ++i) {
            typesInByte[i] = types[i].serialize();
        }
        this.types = typesInByte;
        byte[] encodingsInByte = new byte[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            encodingsInByte[i] = encodings[i].serialize();
        }
        this.encodings = encodingsInByte;
        this.encodingConverters = new TSEncodingBuilder[subMeasurements.length];
        this.compressor = compressionType.serialize();
    }

    public VectorMeasurementSchema(String deviceId, String[] subMeasurements, TSDataType[] types) {
        int i;
        this.deviceId = deviceId;
        this.measurementsToIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < subMeasurements.length; ++i) {
            this.measurementsToIndexMap.put(subMeasurements[i], i);
        }
        this.types = new byte[types.length];
        for (i = 0; i < types.length; ++i) {
            this.types[i] = types[i].serialize();
        }
        this.encodings = new byte[types.length];
        for (i = 0; i < types.length; ++i) {
            this.encodings[i] = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder(types[i])).serialize();
        }
        this.encodingConverters = new TSEncodingBuilder[subMeasurements.length];
        this.compressor = TSFileDescriptor.getInstance().getConfig().getCompressor().serialize();
    }

    public VectorMeasurementSchema(String deviceId, String[] subMeasurements, TSDataType[] types, TSEncoding[] encodings) {
        this(deviceId, subMeasurements, types, encodings, TSFileDescriptor.getInstance().getConfig().getCompressor());
    }

    @Override
    public MeasurementSchemaType getSchemaType() {
        return MeasurementSchemaType.VECTOR_MEASUREMENT_SCHEMA;
    }

    @Override
    public String getMeasurementName() {
        return this.deviceId;
    }

    @Override
    public CompressionType getCompressor() {
        return CompressionType.deserialize(this.compressor);
    }

    @Override
    public TSEncoding getEncodingType() {
        throw new UnsupportedOperationException("unsupported method for VectorMeasurementSchema");
    }

    @Override
    public TSDataType getType() {
        return TSDataType.VECTOR;
    }

    @Override
    public byte getTypeInByte() {
        return 6;
    }

    @Override
    public void setDataType(TSDataType dataType) {
        throw new UnsupportedOperationException("unsupported method for VectorMeasurementSchema");
    }

    @Override
    public TSEncoding getTimeTSEncoding() {
        return TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    }

    @Override
    public Encoder getTimeEncoder() {
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        return TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType);
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException("unsupported method for VectorMeasurementSchema");
    }

    @Override
    public Map<String, String> getProps() {
        throw new UnsupportedOperationException("unsupported method for VectorMeasurementSchema");
    }

    @Override
    public List<String> getSubMeasurementsList() {
        String[] measurements = new String[this.measurementsToIndexMap.size()];
        for (Map.Entry<String, Integer> entry : this.measurementsToIndexMap.entrySet()) {
            measurements[entry.getValue().intValue()] = entry.getKey();
        }
        return Arrays.asList(measurements);
    }

    @Override
    public List<TSDataType> getSubMeasurementsTSDataTypeList() {
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        for (byte dataType : this.types) {
            dataTypeList.add(TSDataType.deserialize((byte)dataType));
        }
        return dataTypeList;
    }

    @Override
    public List<TSEncoding> getSubMeasurementsTSEncodingList() {
        ArrayList<TSEncoding> encodingList = new ArrayList<TSEncoding>();
        for (byte encoding : this.encodings) {
            encodingList.add(TSEncoding.deserialize(encoding));
        }
        return encodingList;
    }

    @Override
    public List<Encoder> getSubMeasurementsEncoderList() {
        ArrayList<Encoder> encoderList = new ArrayList<Encoder>();
        for (int i = 0; i < this.encodings.length; ++i) {
            TSEncoding encoding = TSEncoding.deserialize(this.encodings[i]);
            if (this.encodingConverters[i] == null) {
                this.encodingConverters[i] = TSEncodingBuilder.getEncodingBuilder(encoding);
                this.encodingConverters[i].initFromProps(null);
            }
            encoderList.add(this.encodingConverters[i].getEncoder(TSDataType.deserialize((byte)this.types[i])));
        }
        return encoderList;
    }

    @Override
    public int getSubMeasurementIndex(String subMeasurement) {
        return this.measurementsToIndexMap.getOrDefault(subMeasurement, -1);
    }

    @Override
    public int getSubMeasurementsCount() {
        return this.measurementsToIndexMap.size();
    }

    @Override
    public boolean containsSubMeasurement(String subMeasurement) {
        return this.measurementsToIndexMap.containsKey(subMeasurement);
    }

    public void addMeasurement(String measurementId, TSDataType dataType, TSEncoding encoding) {
        this.measurementsToIndexMap.put(measurementId, this.measurementsToIndexMap.size());
        byte[] typesInByte = new byte[this.measurementsToIndexMap.size()];
        if (this.measurementsToIndexMap.size() - 1 >= 0) {
            System.arraycopy(this.types, 0, typesInByte, 0, this.measurementsToIndexMap.size() - 1);
        }
        typesInByte[typesInByte.length - 1] = dataType.serialize();
        this.types = typesInByte;
        byte[] encodingsInByte = new byte[this.measurementsToIndexMap.size()];
        if (this.measurementsToIndexMap.size() - 1 >= 0) {
            System.arraycopy(this.encodings, 0, encodingsInByte, 0, this.measurementsToIndexMap.size() - 1);
        }
        encodingsInByte[encodingsInByte.length - 1] = encoding.serialize();
        this.encodings = encodingsInByte;
        this.encodingConverters = new TSEncodingBuilder[this.measurementsToIndexMap.size()];
    }

    @Override
    public int serializedSize() {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.sizeToWrite(this.deviceId);
        byteLen += 4;
        for (Map.Entry<String, Integer> entry : this.measurementsToIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.sizeToWrite(entry.getKey());
            byteLen += 4;
        }
        return byteLen += (this.types.length + this.encodings.length + 1) * 1;
    }

    @Override
    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceId, buffer);
        byteLen += ReadWriteIOUtils.write(this.measurementsToIndexMap.size(), buffer);
        for (Map.Entry<String, Integer> entry : this.measurementsToIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
            byteLen += ReadWriteIOUtils.write((int)entry.getValue(), buffer);
        }
        for (Object type : (Object)this.types) {
            byteLen += ReadWriteIOUtils.write((byte)type, buffer);
        }
        for (Object encoding : (Object)this.encodings) {
            byteLen += ReadWriteIOUtils.write((byte)encoding, buffer);
        }
        return byteLen += ReadWriteIOUtils.write(this.compressor, buffer);
    }

    @Override
    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.measurementsToIndexMap.size(), outputStream);
        for (Map.Entry<String, Integer> entry : this.measurementsToIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
            byteLen += ReadWriteIOUtils.write((int)entry.getValue(), outputStream);
        }
        for (Object type : (Object)this.types) {
            byteLen += ReadWriteIOUtils.write((byte)type, outputStream);
        }
        for (Object encoding : (Object)this.encodings) {
            byteLen += ReadWriteIOUtils.write((byte)encoding, outputStream);
        }
        return byteLen += ReadWriteIOUtils.write(this.compressor, outputStream);
    }

    @Override
    public int partialSerializeTo(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, outputStream);
        return 1 + this.serializeTo(outputStream);
    }

    @Override
    public boolean isLogicalView() {
        return false;
    }

    @Override
    public int partialSerializeTo(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)1, buffer);
        return 1 + this.serializeTo(buffer);
    }

    public static VectorMeasurementSchema partialDeserializeFrom(ByteBuffer buffer) {
        return VectorMeasurementSchema.deserializeFrom(buffer);
    }

    public static VectorMeasurementSchema deserializeFrom(InputStream inputStream) throws IOException {
        VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema();
        vectorMeasurementSchema.deviceId = ReadWriteIOUtils.readString(inputStream);
        int measurementSize = ReadWriteIOUtils.readInt(inputStream);
        HashMap<String, Integer> measurementsToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < measurementSize; ++i) {
            measurementsToIndexMap.put(ReadWriteIOUtils.readString(inputStream), ReadWriteIOUtils.readInt(inputStream));
        }
        vectorMeasurementSchema.measurementsToIndexMap = measurementsToIndexMap;
        byte[] types = new byte[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            types[i] = ReadWriteIOUtils.readByte(inputStream);
        }
        vectorMeasurementSchema.types = types;
        byte[] encodings = new byte[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            encodings[i] = ReadWriteIOUtils.readByte(inputStream);
        }
        vectorMeasurementSchema.encodings = encodings;
        vectorMeasurementSchema.compressor = ReadWriteIOUtils.readByte(inputStream);
        return vectorMeasurementSchema;
    }

    public static VectorMeasurementSchema deserializeFrom(ByteBuffer buffer) {
        VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema();
        vectorMeasurementSchema.deviceId = ReadWriteIOUtils.readString(buffer);
        int measurementSize = ReadWriteIOUtils.readInt(buffer);
        HashMap<String, Integer> measurementsToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < measurementSize; ++i) {
            measurementsToIndexMap.put(ReadWriteIOUtils.readString(buffer), ReadWriteIOUtils.readInt(buffer));
        }
        vectorMeasurementSchema.measurementsToIndexMap = measurementsToIndexMap;
        byte[] types = new byte[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            types[i] = ReadWriteIOUtils.readByte(buffer);
        }
        vectorMeasurementSchema.types = types;
        byte[] encodings = new byte[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            encodings[i] = ReadWriteIOUtils.readByte(buffer);
        }
        vectorMeasurementSchema.encodings = encodings;
        vectorMeasurementSchema.compressor = ReadWriteIOUtils.readByte(buffer);
        return vectorMeasurementSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorMeasurementSchema that = (VectorMeasurementSchema)o;
        return Arrays.equals(this.types, that.types) && Arrays.equals(this.encodings, that.encodings) && Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.compressor, that.compressor);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.types, this.encodings, this.compressor);
    }

    @Override
    public int compareTo(VectorMeasurementSchema o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.deviceId.compareTo(o.deviceId);
    }

    public String toString() {
        StringContainer sc = new StringContainer("");
        sc.addTail(this.deviceId, ",");
        for (Map.Entry<String, Integer> entry : this.measurementsToIndexMap.entrySet()) {
            sc.addTail("[", entry.getKey(), ",", TSDataType.deserialize((byte)this.types[entry.getValue()]).toString(), ",", TSEncoding.deserialize(this.encodings[entry.getValue()]).toString());
            sc.addTail("],");
        }
        sc.addTail(CompressionType.deserialize(this.compressor).toString());
        return sc.toString();
    }
}

