/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.BatchDataFactory;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.page.LazyLoadPageData;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class ValuePageReader {
    private static final int MASK = 128;
    private final PageHeader pageHeader;
    private final TSDataType dataType;
    private final Decoder valueDecoder;
    private byte[] bitmap;
    private int size;
    protected ByteBuffer valueBuffer;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;
    private LazyLoadPageData lazyLoadPageData;

    public ValuePageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.pageHeader = pageHeader;
        if (pageData != null) {
            this.splitDataToBitmapAndValue(pageData);
        }
        this.valueBuffer = pageData;
    }

    public ValuePageReader(PageHeader pageHeader, LazyLoadPageData lazyLoadPageData, TSDataType dataType, Decoder valueDecoder) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.pageHeader = pageHeader;
        this.lazyLoadPageData = lazyLoadPageData;
    }

    private void splitDataToBitmapAndValue(ByteBuffer pageData) {
        if (!pageData.hasRemaining()) {
            return;
        }
        this.size = ReadWriteIOUtils.readInt(pageData);
        this.bitmap = new byte[(this.size + 7) / 8];
        pageData.get(this.bitmap);
        this.valueBuffer = pageData.slice();
    }

    private void uncompressDataIfNecessary() throws IOException {
        if (this.lazyLoadPageData != null && this.valueBuffer == null) {
            ByteBuffer pageData = this.lazyLoadPageData.uncompressPageData(this.pageHeader);
            this.splitDataToBitmapAndValue(pageData);
            this.valueBuffer = pageData;
            this.lazyLoadPageData = null;
        }
    }

    public BatchData nextBatch(long[] timeBatch, boolean ascending, Filter filter) throws IOException {
        this.uncompressDataIfNecessary();
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        block8: for (int i = 0; i < timeBatch.length; ++i) {
            if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
            long timestamp = timeBatch[i];
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyBoolean(timestamp, aBoolean)) continue block8;
                    pageData.putBoolean(timestamp, aBoolean);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyInteger(timestamp, anInt)) continue block8;
                    pageData.putInt(timestamp, anInt);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyLong(timestamp, aLong)) continue block8;
                    pageData.putLong(timestamp, aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyFloat(timestamp, aFloat)) continue block8;
                    pageData.putFloat(timestamp, aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyDouble(timestamp, aDouble)) continue block8;
                    pageData.putDouble(timestamp, aDouble);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || filter != null && !filter.satisfyBinary(timestamp, aBinary)) continue block8;
                    pageData.putBinary(timestamp, aBinary);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
                }
            }
        }
        return pageData.flip();
    }

    public TsPrimitiveType nextValue(long timestamp, int timeIndex) throws IOException {
        this.uncompressDataIfNecessary();
        TsPrimitiveType.TsBoolean resultValue = null;
        if (this.valueBuffer == null || (this.bitmap[timeIndex / 8] & 0xFF & 128 >>> timeIndex % 8) == 0) {
            return null;
        }
        switch (this.dataType) {
            case BOOLEAN: {
                boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsBoolean(aBoolean);
                break;
            }
            case INT32: 
            case DATE: {
                int anInt = this.valueDecoder.readInt(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsInt(anInt);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long aLong = this.valueDecoder.readLong(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsLong(aLong);
                break;
            }
            case FLOAT: {
                float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsFloat(aFloat);
                break;
            }
            case DOUBLE: {
                double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsDouble(aDouble);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                if (this.isDeleted(timestamp)) break;
                resultValue = new TsPrimitiveType.TsBinary(aBinary);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
            }
        }
        return resultValue;
    }

    public TsPrimitiveType[] nextValueBatch(long[] timeBatch) throws IOException {
        this.uncompressDataIfNecessary();
        TsPrimitiveType[] valueBatch = new TsPrimitiveType[this.size];
        if (this.valueBuffer == null) {
            return valueBatch;
        }
        block8: for (int i = 0; i < this.size; ++i) {
            if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsBoolean(aBoolean);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsInt(anInt);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsLong(aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsFloat(aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsDouble(aDouble);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timeBatch[i])) continue block8;
                    valueBatch[i] = new TsPrimitiveType.TsBinary(aBinary);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
                }
            }
        }
        return valueBatch;
    }

    public void writeColumnBuilderWithNextBatch(int readEndIndex, ColumnBuilder columnBuilder, boolean[] keepCurrentRow, boolean[] isDeleted) throws IOException {
        this.uncompressDataIfNecessary();
        if (this.valueBuffer == null) {
            for (int i = 0; i < readEndIndex; ++i) {
                if (!keepCurrentRow[i]) continue;
                columnBuilder.appendNull();
            }
            return;
        }
        block9: for (int i = 0; i < readEndIndex; ++i) {
            if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                if (!keepCurrentRow[i]) continue;
                columnBuilder.appendNull();
                continue;
            }
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeBoolean(aBoolean);
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeInt(anInt);
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeLong(aLong);
                    continue block9;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeFloat(aFloat);
                    continue block9;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeDouble(aDouble);
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    if (isDeleted[i]) {
                        columnBuilder.appendNull();
                        continue block9;
                    }
                    columnBuilder.writeBinary(aBinary);
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
                }
            }
        }
    }

    public void writeColumnBuilderWithNextBatch(int readEndIndex, ColumnBuilder columnBuilder, boolean[] keepCurrentRow) throws IOException {
        this.uncompressDataIfNecessary();
        if (this.valueBuffer == null) {
            for (int i = 0; i < readEndIndex; ++i) {
                if (!keepCurrentRow[i]) continue;
                columnBuilder.appendNull();
            }
            return;
        }
        block9: for (int i = 0; i < readEndIndex; ++i) {
            if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                if (!keepCurrentRow[i]) continue;
                columnBuilder.appendNull();
                continue;
            }
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeBoolean(aBoolean);
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeInt(anInt);
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeLong(aLong);
                    continue block9;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeFloat(aFloat);
                    continue block9;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeDouble(aDouble);
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (!keepCurrentRow[i]) continue block9;
                    columnBuilder.writeBinary(aBinary);
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
                }
            }
        }
    }

    public void writeColumnBuilderWithNextBatch(int readStartIndex, int readEndIndex, ColumnBuilder columnBuilder) throws IOException {
        this.uncompressDataIfNecessary();
        if (this.valueBuffer == null) {
            columnBuilder.appendNull(readEndIndex - readStartIndex);
            return;
        }
        switch (this.dataType) {
            case BOOLEAN: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readBoolean(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    columnBuilder.writeBoolean(aBoolean);
                }
                break;
            }
            case INT32: 
            case DATE: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readInt(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    int aInt = this.valueDecoder.readInt(this.valueBuffer);
                    columnBuilder.writeInt(aInt);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readLong(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    columnBuilder.writeLong(aLong);
                }
                break;
            }
            case FLOAT: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readFloat(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    columnBuilder.writeFloat(aFloat);
                }
                break;
            }
            case DOUBLE: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readDouble(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    columnBuilder.writeDouble(aDouble);
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                int i;
                for (i = 0; i < readStartIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
                    this.valueDecoder.readBinary(this.valueBuffer);
                }
                for (i = readStartIndex; i < readEndIndex; ++i) {
                    if ((this.bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    columnBuilder.writeBinary(aBinary);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.pageHeader.getStatistics();
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    public boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }

    public void fillIsDeleted(long[] timestamp, boolean[] isDeleted) {
        int n = timestamp.length;
        for (int i = 0; i < n; ++i) {
            isDeleted[i] = this.isDeleted(timestamp[i]);
        }
    }

    public void fillIsDeleted(long[] timestamp, boolean[] isDeleted, boolean[] keepCurrentRow) {
        int n = timestamp.length;
        for (int i = 0; i < n; ++i) {
            if (!keepCurrentRow[i]) continue;
            isDeleted[i] = this.isDeleted(timestamp[i]);
        }
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public byte[] getBitmap() throws IOException {
        this.uncompressDataIfNecessary();
        return Arrays.copyOf(this.bitmap, this.bitmap.length);
    }
}

