/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class ConfigRegionListeningFilter {
    private static final Map<PartialPath, List<ConfigPhysicalPlanType>> OPTION_PLAN_MAP = new HashMap<PartialPath, List<ConfigPhysicalPlanType>>();

    static boolean shouldPlanBeListened(ConfigPhysicalPlan plan) {
        ConfigPhysicalPlanType type = plan.getType();
        if (type.equals((Object)ConfigPhysicalPlanType.CommitSetSchemaTemplate) && ((CommitSetSchemaTemplatePlan)plan).isRollback()) {
            return false;
        }
        return type.equals((Object)ConfigPhysicalPlanType.PipeEnriched) || type.equals((Object)ConfigPhysicalPlanType.UnsetTemplate) || OPTION_PLAN_MAP.values().stream().anyMatch(types -> types.contains((Object)type));
    }

    public static Set<ConfigPhysicalPlanType> parseListeningPlanTypeSet(PipeParameters parameters) throws IllegalPathException {
        HashSet<ConfigPhysicalPlanType> planTypes = new HashSet<ConfigPhysicalPlanType>();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getInclusionString((PipeParameters)parameters));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getExclusionString((PipeParameters)parameters));
        inclusionOptions.forEach(inclusion -> planTypes.addAll(ConfigRegionListeningFilter.getOptionsByPrefix(inclusion)));
        exclusionOptions.forEach(exclusion -> planTypes.removeAll(ConfigRegionListeningFilter.getOptionsByPrefix(exclusion)));
        if (!TreePattern.isTreeModelDataAllowToBeCaptured((PipeParameters)parameters)) {
            PipeInclusionOptions.treeOnlySyncPrefixes.forEach(prefix -> planTypes.removeAll(ConfigRegionListeningFilter.getOptionsByPrefix(prefix)));
        }
        if (!TablePattern.isTableModelDataAllowToBeCaptured((PipeParameters)parameters)) {
            PipeInclusionOptions.tableOnlySyncPrefixes.forEach(prefix -> planTypes.removeAll(ConfigRegionListeningFilter.getOptionsByPrefix(prefix)));
        }
        return planTypes;
    }

    private static Set<ConfigPhysicalPlanType> getOptionsByPrefix(PartialPath prefix) {
        return OPTION_PLAN_MAP.keySet().stream().filter(path -> path.matchPrefixPath(prefix)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private ConfigRegionListeningFilter() {
    }

    static {
        try {
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.create"), Collections.singletonList(ConfigPhysicalPlanType.CreateDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.alter"), Collections.singletonList(ConfigPhysicalPlanType.AlterDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.drop"), Collections.singletonList(ConfigPhysicalPlanType.DeleteDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.create"), Collections.singletonList(ConfigPhysicalPlanType.CreateSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.set"), Collections.singletonList(ConfigPhysicalPlanType.CommitSetSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.alter"), Collections.singletonList(ConfigPhysicalPlanType.ExtendSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.drop"), Collections.singletonList(ConfigPhysicalPlanType.DropSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.unset"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.UnsetTemplate, ConfigPhysicalPlanType.PipeUnsetTemplate)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.drop"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeleteTimeSeries));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.drop"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeleteLogicalView));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.deactivate"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeactivateTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.table.create"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.CommitCreateTable, ConfigPhysicalPlanType.PipeCreateTable, ConfigPhysicalPlanType.AddTableColumn)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.table.alter"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.SetTableProperties, ConfigPhysicalPlanType.SetTableComment, ConfigPhysicalPlanType.SetTableColumnComment)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.table.drop"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.CommitDeleteTable, ConfigPhysicalPlanType.CommitDeleteColumn, ConfigPhysicalPlanType.PipeDeleteDevices)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.ttl"), Collections.singletonList(ConfigPhysicalPlanType.SetTTL));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.create"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.CreateRole, ConfigPhysicalPlanType.RCreateRole)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.drop"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.DropRole, ConfigPhysicalPlanType.RDropRole)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.grant"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.GrantRole, ConfigPhysicalPlanType.RGrantRoleAll, ConfigPhysicalPlanType.RGrantRoleSysPri)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.revoke"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RevokeRole, ConfigPhysicalPlanType.RRevokeRoleAll, ConfigPhysicalPlanType.RRevokeRoleSysPri)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.grant.table"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RGrantRoleAny, ConfigPhysicalPlanType.RGrantRoleDBPriv, ConfigPhysicalPlanType.RGrantRoleTBPriv)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.revoke.table"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RRevokeRoleAny, ConfigPhysicalPlanType.RRevokeRoleDBPriv, ConfigPhysicalPlanType.RRevokeRoleTBPriv)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.create"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.CreateUser, ConfigPhysicalPlanType.RCreateUser, ConfigPhysicalPlanType.CreateUserWithRawPassword)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.alter"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.UpdateUser, ConfigPhysicalPlanType.RUpdateUser)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.drop"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.DropUser, ConfigPhysicalPlanType.RDropUser)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.grant"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.GrantUser, ConfigPhysicalPlanType.GrantRoleToUser, ConfigPhysicalPlanType.RGrantUserRole, ConfigPhysicalPlanType.RGrantUserAll, ConfigPhysicalPlanType.RGrantUserSysPri)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.revoke"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RevokeUser, ConfigPhysicalPlanType.RevokeRoleFromUser, ConfigPhysicalPlanType.RRevokeUserRole, ConfigPhysicalPlanType.RGrantUserAll, ConfigPhysicalPlanType.RGrantUserSysPri)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.grant.table"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RGrantUserAny, ConfigPhysicalPlanType.RGrantUserDBPriv, ConfigPhysicalPlanType.RGrantUserTBPriv)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.revoke.table"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RRevokeUserAny, ConfigPhysicalPlanType.RRevokeUserDBPriv, ConfigPhysicalPlanType.RRevokeUserTBPriv)));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

