/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionSourceFileDeletedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.MetadataInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;

public class CompactionEstimateUtils {
    public static FileInfo calculateFileInfo(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
        while (deviceIterator.hasNext()) {
            int deviceChunkNum = 0;
            int alignedSeriesNumInDevice = 0;
            Pair deviceWithIsAlignedPair = deviceIterator.next();
            IDeviceID device = (IDeviceID)deviceWithIsAlignedPair.left;
            boolean isAlignedDevice = (Boolean)deviceWithIsAlignedPair.right;
            Iterator measurementChunkMetadataListMapIterator = reader.getMeasurementChunkMetadataListMapIterator(device);
            while (measurementChunkMetadataListMapIterator.hasNext()) {
                Map measurementChunkMetadataListMap = (Map)measurementChunkMetadataListMapIterator.next();
                if (isAlignedDevice) {
                    alignedSeriesNumInDevice += measurementChunkMetadataListMap.size();
                }
                for (Map.Entry measurementChunkMetadataList : measurementChunkMetadataListMap.entrySet()) {
                    int currentChunkMetadataListSize = ((List)measurementChunkMetadataList.getValue()).size();
                    deviceChunkNum += currentChunkMetadataListSize;
                    totalChunkNum += currentChunkMetadataListSize;
                    maxChunkNum = Math.max(maxChunkNum, currentChunkMetadataListSize);
                }
            }
            if (isAlignedDevice) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, alignedSeriesNumInDevice);
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
        }
        long averageChunkMetadataSize = totalChunkNum == 0 ? 0L : reader.getAllMetadataSize() / (long)totalChunkNum;
        return new FileInfo(totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum, averageChunkMetadataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MetadataInfo collectMetadataInfo(List<TsFileResource> resources, CompactionType taskType) throws IOException {
        CompactionEstimateUtils.addReadLock(resources);
        MetadataInfo metadataInfo = new MetadataInfo();
        long cost = 0L;
        HashMap<IDeviceID, Long> deviceMetadataSizeMap = new HashMap<IDeviceID, Long>();
        try {
            for (TsFileResource resource : resources) {
                cost += resource.getTotalModSizeInByte();
                try (CompactionTsFileReader reader = new CompactionTsFileReader(resource.getTsFilePath(), taskType);){
                    for (Map.Entry<IDeviceID, Long> entry : CompactionEstimateUtils.getDeviceMetadataSizeMapAndCollectMetadataInfo(reader, metadataInfo).entrySet()) {
                        deviceMetadataSizeMap.merge(entry.getKey(), entry.getValue(), Long::sum);
                    }
                }
            }
            metadataInfo.metadataMemCost = cost + deviceMetadataSizeMap.values().stream().max(Long::compareTo).orElse(0L);
            MetadataInfo metadataInfo2 = metadataInfo;
            return metadataInfo2;
        }
        finally {
            CompactionEstimateUtils.releaseReadLock(resources);
        }
    }

    static Map<IDeviceID, Long> getDeviceMetadataSizeMapAndCollectMetadataInfo(CompactionTsFileReader reader, MetadataInfo metadataInfo) throws IOException {
        HashMap<IDeviceID, Long> deviceMetadataSizeMap = new HashMap<IDeviceID, Long>();
        TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
        while (deviceIterator.hasNext()) {
            Pair deviceAlignedPair = deviceIterator.next();
            IDeviceID deviceID = (IDeviceID)deviceAlignedPair.getLeft();
            boolean isAligned = (Boolean)deviceAlignedPair.getRight();
            metadataInfo.hasAlignedSeries |= isAligned;
            MetadataIndexNode firstMeasurementNodeOfCurrentDevice = deviceIterator.getFirstMeasurementNodeOfCurrentDevice();
            long totalTimeseriesMetadataSizeOfCurrentDevice = 0L;
            Map<String, Pair<Long, Long>> timeseriesMetadataOffsetByDevice = reader.getTimeseriesMetadataOffsetByDevice(firstMeasurementNodeOfCurrentDevice);
            for (Pair<Long, Long> offsetPair : timeseriesMetadataOffsetByDevice.values()) {
                totalTimeseriesMetadataSizeOfCurrentDevice += (Long)offsetPair.right - (Long)offsetPair.left;
            }
            deviceMetadataSizeMap.put(deviceID, totalTimeseriesMetadataSizeOfCurrentDevice);
        }
        return deviceMetadataSizeMap;
    }

    public static boolean shouldUseRoughEstimatedResult(long roughEstimatedMemCost) {
        return roughEstimatedMemCost > 0L && (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * roughEstimatedMemCost < SystemInfo.getInstance().getMemorySizeForCompaction();
    }

    public static void addReadLock(List<TsFileResource> resources) throws CompactionSourceFileDeletedException {
        for (int i = 0; i < resources.size(); ++i) {
            TsFileResource resource = resources.get(i);
            resource.readLock();
            if (!resource.isDeleted()) continue;
            for (int j = 0; j <= i; ++j) {
                resources.get(j).readUnlock();
            }
            throw new CompactionSourceFileDeletedException("source file " + resource.getTsFilePath() + " is deleted");
        }
    }

    public static void releaseReadLock(List<TsFileResource> resources) {
        resources.forEach(TsFileResource::readUnlock);
    }
}

