/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;

public class SingleColumn
extends SelectItem {
    @Nullable
    private final Identifier alias;
    private final Expression expression;

    public SingleColumn(Expression expression) {
        super(null);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = null;
    }

    public SingleColumn(NodeLocation location, Expression expression) {
        super(Objects.requireNonNull(location, "location is null"));
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = null;
    }

    public SingleColumn(Expression expression, Identifier alias) {
        super(null);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
    }

    public SingleColumn(NodeLocation location, Expression expression, Identifier alias) {
        super(Objects.requireNonNull(location, "location is null"));
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
    }

    public Optional<Identifier> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    @Override
    public String toString() {
        if (this.alias != null) {
            return this.expression.toString() + " " + this.alias;
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SingleColumn.sameClass(this, other)) {
            return false;
        }
        if (this.alias == null) {
            return ((SingleColumn)other).alias == null;
        }
        return this.alias.equals(((SingleColumn)other).alias);
    }
}

