/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.QueryExecutor;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModelQueryFragmentPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableModelQueryFragmentPlanner.class);
    private final SubPlan subPlan;
    private final Analysis analysis;
    private final List<FragmentInstance> fragmentInstanceList = new ArrayList<FragmentInstance>();
    private final MPPQueryContext queryContext;
    private final Map<PlanFragmentId, FragmentInstance> instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
    private final Map<PlanNodeId, Pair<PlanFragmentId, PlanNode>> planNodeMap = new HashMap<PlanNodeId, Pair<PlanFragmentId, PlanNode>>();
    private final Map<TDataNodeLocation, List<FragmentInstance>> dataNodeFIMap = new HashMap<TDataNodeLocation, List<FragmentInstance>>();
    private final Map<PlanNodeId, NodeDistribution> nodeDistributionMap;

    TableModelQueryFragmentPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext queryContext, Map<PlanNodeId, NodeDistribution> nodeDistributionMap) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = queryContext;
        this.nodeDistributionMap = nodeDistributionMap;
    }

    public List<FragmentInstance> plan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        for (PlanFragment fragment : this.subPlan.getPlanFragmentList()) {
            this.recordPlanNodeRelation(fragment.getPlanNodeTree(), fragment.getId());
            this.produceFragmentInstance(fragment, this.nodeDistributionMap);
        }
        this.fragmentInstanceList.forEach(fi -> fi.setDataNodeFINum(this.dataNodeFIMap.get(fi.getHostDataNode()).size()));
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), (Pair<PlanFragmentId, PlanNode>)new Pair((Object)planFragmentId, (Object)root));
        root.getChildren().forEach(child -> this.recordPlanNodeRelation((PlanNode)child, planFragmentId));
    }

    private void produceFragmentInstance(PlanFragment fragment, Map<PlanNodeId, NodeDistribution> nodeDistributionMap) {
        FragmentInstance fragmentInstance = new FragmentInstance(fragment, fragment.getId().genFragmentInstanceId(), QueryType.READ, this.queryContext.getTimeOut() - (System.currentTimeMillis() - this.queryContext.getStartTime()), this.queryContext.getSession(), this.queryContext.isExplainAnalyze(), fragment.isRoot());
        TRegionReplicaSet regionReplicaSet = fragment.getTargetRegionForTableModel(nodeDistributionMap);
        if (regionReplicaSet == null || regionReplicaSet.getRegionId() == null) {
            TDataNodeLocation dataNodeLocation = fragment.getTargetLocation();
            if (dataNodeLocation != null) {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(dataNodeLocation));
            } else {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(DataNodeEndPoints.getLocalDataNodeLocation()));
            }
        } else {
            fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
            fragmentInstance.setHostDataNode(this.selectTargetDataNode(regionReplicaSet));
        }
        this.dataNodeFIMap.compute(fragmentInstance.getHostDataNode(), (k, v) -> {
            if (v == null) {
                v = new ArrayList<FragmentInstance>();
            }
            v.add(fragmentInstance);
            return v;
        });
        Statement statement = this.analysis.getStatement();
        if (this.analysis.isQuery() || statement instanceof ShowDevice || statement instanceof CountDevice) {
            fragmentInstance.getFragment().generateTableModelTypeProvider(this.queryContext.getTypeProvider());
        }
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }

    private TDataNodeLocation selectTargetDataNode(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null || regionReplicaSet.getDataNodeLocations() == null || regionReplicaSet.getDataNodeLocations().isEmpty()) {
            throw new IllegalArgumentException(String.format("RegionReplicaSet is invalid: %s", regionReplicaSet));
        }
        String readConsistencyLevel = IoTDBDescriptor.getInstance().getConfig().getReadConsistencyLevel();
        boolean selectRandomDataNode = "weak".equals(readConsistencyLevel);
        List<TDataNodeLocation> availableDataNodes = this.filterAvailableTDataNode(regionReplicaSet.getDataNodeLocations());
        if (availableDataNodes.isEmpty()) {
            String errorMsg = String.format("All replicas for region[%s] are not available in these DataNodes[%s]", regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations());
            throw new IllegalArgumentException(errorMsg);
        }
        if (regionReplicaSet.getDataNodeLocationsSize() != availableDataNodes.size()) {
            LOGGER.info("Available replicas: {}", availableDataNodes);
        }
        int targetIndex = !selectRandomDataNode || this.queryContext.getSession() == null ? 0 : (int)(this.queryContext.getSession().getSessionId() % (long)availableDataNodes.size());
        return availableDataNodes.get(targetIndex);
    }

    private List<TDataNodeLocation> filterAvailableTDataNode(List<TDataNodeLocation> originalDataNodeList) {
        LinkedList<TDataNodeLocation> result = new LinkedList<TDataNodeLocation>();
        for (TDataNodeLocation dataNodeLocation : originalDataNodeList) {
            if (!this.isAvailableDataNode(dataNodeLocation)) continue;
            result.add(dataNodeLocation);
        }
        return result;
    }

    private boolean isAvailableDataNode(TDataNodeLocation dataNodeLocation) {
        for (TEndPoint endPoint : this.queryContext.getEndPointBlackList()) {
            if (!endPoint.equals(dataNodeLocation.internalEndPoint)) continue;
            return false;
        }
        return true;
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getPlanNodeTree();
            if (!(rootNode instanceof MultiChildrenSinkNode)) continue;
            MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)rootNode;
            for (DownStreamChannelLocation downStreamChannelLocation : sinkNode.getDownStreamChannelLocationList()) {
                PlanNodeId downStreamNodeId = new PlanNodeId(downStreamChannelLocation.getRemotePlanNodeId());
                FragmentInstance downStreamInstance = this.findDownStreamInstance(downStreamNodeId);
                downStreamChannelLocation.setRemoteEndpoint(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint());
                downStreamChannelLocation.setRemoteFragmentInstanceId(downStreamInstance.getId().toThrift());
                PlanNode downStreamExchangeNode = (PlanNode)this.planNodeMap.get((Object)downStreamNodeId).right;
                ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
            }
        }
    }

    private FragmentInstance findDownStreamInstance(PlanNodeId exchangeNodeId) {
        return this.instanceMap.get(this.planNodeMap.get((Object)exchangeNodeId).left);
    }
}

