/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LastByAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LastByAccumulator.class);
    protected final TSDataType xDataType;
    protected final TSDataType yDataType;
    protected final boolean xIsTimeColumn;
    protected final boolean yIsTimeColumn;
    private long yLastTime = Long.MIN_VALUE;
    private final TsPrimitiveType xResult;
    private boolean xIsNull = true;
    protected boolean initResult = false;

    public LastByAccumulator(TSDataType xDataType, TSDataType yDataType, boolean xIsTimeColumn, boolean yIsTimeColumn) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        this.xIsTimeColumn = xIsTimeColumn;
        this.yIsTimeColumn = yIsTimeColumn;
        this.xResult = TsPrimitiveType.getByType((TSDataType)xDataType);
    }

    public boolean xIsTimeColumn() {
        return this.xIsTimeColumn;
    }

    public boolean yIsTimeColumn() {
        return this.yIsTimeColumn;
    }

    public boolean hasInitResult() {
        return this.initResult;
    }

    public long getLastTimeOfY() {
        return this.yLastTime;
    }

    public boolean isXNull() {
        return this.xIsNull;
    }

    public TsPrimitiveType getXResult() {
        return this.xResult;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new LastByAccumulator(this.xDataType, this.yDataType, this.xIsTimeColumn, this.yIsTimeColumn);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 3 ? 1 : 0) != 0, (Object)"Length of input Column[] for LastBy should be 3");
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastBy: %s", this.yDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of LastBy should be BinaryColumn");
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long curTime = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
            ++offset;
            if (isXNull) {
                if (this.initResult && curTime <= this.yLastTime) continue;
                this.initResult = true;
                this.yLastTime = curTime;
                this.xIsNull = true;
                continue;
            }
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    int xIntVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntLastValue(xIntVal, curTime);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongLastValue(longVal, curTime);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatLastValue(floatVal, curTime);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleLastValue(doubleVal, curTime);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryLastValue(binaryVal, curTime);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanLastValue(boolVal, curTime);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last Aggregation: %s", this.yDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of LastBy should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(this.xDataType, this.yLastTime, this.xIsNull, this.xResult)));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult || this.xIsNull) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.xResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.xResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.xResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastBy: %s", this.xDataType));
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        block14: {
            Statistics yStatistics;
            block12: {
                Statistics xStatistics;
                block13: {
                    xStatistics = statistics[0];
                    yStatistics = statistics[1];
                    if (this.yIsTimeColumn && yStatistics == null || this.xIsTimeColumn && xStatistics == null) {
                        return;
                    }
                    if (!this.yIsTimeColumn) break block12;
                    if (xStatistics != null && xStatistics.getEndTime() >= yStatistics.getEndTime()) break block13;
                    if (!this.initResult || yStatistics.getEndTime() > this.yLastTime) {
                        this.initResult = true;
                        this.yLastTime = yStatistics.getEndTime();
                        this.xIsNull = true;
                    }
                    break block14;
                }
                if (this.initResult && yStatistics.getEndTime() <= this.yLastTime) break block14;
                this.initResult = true;
                this.yLastTime = yStatistics.getEndTime();
                this.xIsNull = false;
                if (xStatistics instanceof TimeStatistics) {
                    this.xResult.setLong(xStatistics.getEndTime());
                    return;
                }
                switch (this.xDataType) {
                    case INT32: 
                    case DATE: {
                        this.xResult.setInt(((Integer)xStatistics.getLastValue()).intValue());
                        break block14;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        this.xResult.setLong(((Long)xStatistics.getLastValue()).longValue());
                        break block14;
                    }
                    case FLOAT: {
                        this.xResult.setFloat(((Float)statistics[0].getLastValue()).floatValue());
                        break block14;
                    }
                    case DOUBLE: {
                        this.xResult.setDouble(((Double)statistics[0].getLastValue()).doubleValue());
                        break block14;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        this.xResult.setBinary((Binary)statistics[0].getLastValue());
                        break block14;
                    }
                    case BOOLEAN: {
                        this.xResult.setBoolean(((Boolean)statistics[0].getLastValue()).booleanValue());
                        break block14;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s in Aggregation: %s", this.yDataType, "last_by"));
                    }
                }
            }
            if (!(yStatistics == null || this.initResult && yStatistics.getEndTime() <= this.yLastTime)) {
                this.initResult = true;
                this.xIsNull = false;
                this.yLastTime = yStatistics.getEndTime();
                this.xResult.setLong(yStatistics.getEndTime());
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.xIsNull = true;
        this.yLastTime = Long.MIN_VALUE;
        this.xResult.reset();
    }

    protected void addIntInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateIntLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateIntLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateIntLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setInt(xColumn.getInt(xIdx));
            }
        }
    }

    protected void updateIntLastValue(int val, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setInt(val);
        }
    }

    protected void addLongInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateLongLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateLongLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateLongLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setLong(xColumn.getLong(xIdx));
            }
        }
    }

    protected void updateLongLastValue(long value, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setLong(value);
        }
    }

    protected void addFloatInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateFloatLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateFloatLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateFloatLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setFloat(xColumn.getFloat(xIdx));
            }
        }
    }

    protected void updateFloatLastValue(float value, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setFloat(value);
        }
    }

    protected void addDoubleInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateDoubleLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateDoubleLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateDoubleLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setDouble(xColumn.getDouble(xIdx));
            }
        }
    }

    protected void updateDoubleLastValue(double val, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setDouble(val);
        }
    }

    protected void addBinaryInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBinaryLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBinaryLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateBinaryLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setBinary(xColumn.getBinary(xIdx));
            }
        }
    }

    protected void updateBinaryLastValue(Binary val, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setBinary(val);
        }
    }

    protected void addBooleanInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBooleanLastValue(xColumn, i, timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBooleanLastValue(xColumn, position, timeColumn.getLong(position));
            }
        }
    }

    protected void updateBooleanLastValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setBoolean(xColumn.getBoolean(xIdx));
            }
        }
    }

    protected void updateBooleanLastValue(boolean val, long curTime) {
        if (!this.initResult || curTime > this.yLastTime) {
            this.initResult = true;
            this.yLastTime = curTime;
            this.xIsNull = false;
            this.xResult.setBoolean(val);
        }
    }
}

