/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionConnection;
import org.apache.thrift.TException;

public class SubscriptionSessionConnection
extends SessionConnection {
    private static final String SHOW_DATA_NODES_COMMAND = "SHOW DATANODES";
    private static final String NODE_ID_COLUMN_NAME = "NodeID";
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String IP_COLUMN_NAME = "RpcAddress";
    private static final String PORT_COLUMN_NAME = "RpcPort";
    private static final String REMOVING_STATUS = "Removing";

    public SubscriptionSessionConnection(Session session, TEndPoint endPoint, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs, String sqlDialect, String database) throws IoTDBConnectionException {
        super(session, endPoint, zoneId, availableNodes, maxRetryCount, retryIntervalInMs, sqlDialect, database);
    }

    public Map<Integer, TEndPoint> fetchAllEndPoints() throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = this.session.executeQueryStatement(SHOW_DATA_NODES_COMMAND);
        SessionDataSet.DataIterator iterator = dataSet.iterator();
        HashMap<Integer, TEndPoint> endPoints = new HashMap<Integer, TEndPoint>();
        while (iterator.next()) {
            if (REMOVING_STATUS.equals(iterator.getString(STATUS_COLUMN_NAME))) continue;
            String ip = iterator.getString(IP_COLUMN_NAME);
            String port = iterator.getString(PORT_COLUMN_NAME);
            if (ip == null || port == null) continue;
            endPoints.put(iterator.getInt(NODE_ID_COLUMN_NAME), new TEndPoint(ip, Integer.parseInt(port)));
        }
        return endPoints;
    }

    public TPipeSubscribeResp pipeSubscribe(TPipeSubscribeReq req) throws TException {
        return this.client.pipeSubscribe(req);
    }
}

