#
#  Licensed to the Apache Software Foundation (ASF) under one or more
#  contributor license agreements.  See the NOTICE file distributed with
#  this work for additional information regarding copyright ownership.
#  The ASF licenses this file to You under the Apache License, Version 2.0
#  (the "License"); you may not use this file except in compliance with
#  the License.  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

from typing import List, Type

from pywy.core.channel import CH_T
from pywy.operators.base import PywyOperator
from pywy.platforms.jvm.context import JVMTranslateContext
from pywy.platforms.jvm.serializable.wayang_jvm_operator import WayangJVMOperator


class JVMExecutionOperator(PywyOperator):

    dispatch_operator: WayangJVMOperator

    translate_context: JVMTranslateContext

    def set_context(self, **kwargs):
        if 'translate_context' not in kwargs:
            return
        self.translate_context = kwargs['translate_context']

    def close_operator(self, op: WayangJVMOperator):
        if self.translate_context is None:
            return

        self.translate_context.add_operator(op)


    def prefix(self) -> str:
        return 'JVM'

    def execute(self, inputs: List[Type[CH_T]], output: List[CH_T]):
        pass
