/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import java.io.Serializable;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.IngressController$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesRetriever$
implements org.apache.streampark.common.util.Logger {
    public static KubernetesRetriever$ MODULE$;
    private final long FLINK_CLIENT_TIMEOUT_SEC;
    private final long FLINK_REST_AWAIT_TIMEOUT_SEC;
    private final int FLINK_REST_RETRY_MAX_ATTEMPTS;
    private final DefaultClusterClientServiceLoader clusterClientServiceLoader;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new KubernetesRetriever$();
    }

    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public long FLINK_CLIENT_TIMEOUT_SEC() {
        return this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    public long FLINK_REST_AWAIT_TIMEOUT_SEC() {
        return this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    public int FLINK_REST_RETRY_MAX_ATTEMPTS() {
        return this.FLINK_REST_RETRY_MAX_ATTEMPTS;
    }

    public KubernetesClient newK8sClient() throws KubernetesClientException {
        return new DefaultKubernetesClient();
    }

    public boolean checkK8sConnection() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.newK8sClient().getVersion() != null).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private DefaultClusterClientServiceLoader clusterClientServiceLoader() {
        return this.clusterClientServiceLoader;
    }

    public Option<ClusterClient<String>> newFinkClusterClient(String clusterId, @Nullable String namespace, Enumeration.Value executeMode) {
        Some some;
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString(DeploymentOptions.TARGET, executeMode.toString());
        flinkConfig.setString(KubernetesConfigOptions.CLUSTER_ID, clusterId);
        flinkConfig.set(ClientOptions.CLIENT_TIMEOUT, (Object)Duration.ofSeconds(this.FLINK_CLIENT_TIMEOUT_SEC()));
        flinkConfig.setLong(RestOptions.AWAIT_LEADER_TIMEOUT, this.FLINK_REST_AWAIT_TIMEOUT_SEC() * 1000L);
        flinkConfig.setInteger(RestOptions.RETRY_MAX_ATTEMPTS, this.FLINK_REST_RETRY_MAX_ATTEMPTS());
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> namespace.isEmpty()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, (String)KubernetesConfigOptions.NAMESPACE.defaultValue());
        } else {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, namespace);
        }
        ClusterClientFactory clientFactory = this.clusterClientServiceLoader().getClusterClientFactory(flinkConfig);
        KubernetesClusterDescriptor clusterProvider = (KubernetesClusterDescriptor)clientFactory.createClusterDescriptor(flinkConfig);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> clusterProvider.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ClusterClient v = (ClusterClient)success.value();
            some = new Some((Object)v);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Get flinkClient error, the error is: ").append(e).toString());
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return some;
    }

    public boolean isDeploymentExists(String name, String namespace) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((AutoCloseable)this.newK8sClient(), (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$1(namespace, name, client)), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$3(x$1))));
    }

    public Option<String> retrieveFlinkRestUrl(ClusterKey clusterKey) {
        Option option;
        Object object = new Object();
        try {
            ClusterClient x$1 = (ClusterClient)this.newFinkClusterClient(clusterKey.clusterId(), clusterKey.namespace(), clusterKey.executeMode()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> {
                String url = IngressController$.MODULE$.ingressUrlAddress(clusterKey.namespace(), clusterKey.clusterId(), (ClusterClient<?>)client);
                MODULE$.logger().info(new StringBuilder(36).append("retrieve flink jobManager rest url: ").append(url).toString());
                client.close();
                return new Some((Object)url);
            };
            Null$ x$3 = Utils$.MODULE$.tryWithResource$default$3((AutoCloseable)x$1, (Function1)x$2);
            option = (Option)Utils$.MODULE$.tryWithResource((AutoCloseable)x$1, (Function1)x$2, null);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$2(String name$1, Deployment e) {
        String string = e.getMetadata().getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$1(String namespace$2, String name$1, KubernetesClient client) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeploymentList)((Listable)((Filterable)client.apps().deployments().inNamespace(namespace$2)).withLabel("type", "flink-native-kubernetes")).list()).getItems()).asScala()).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$2(name$1, e)));
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$3(Throwable x$1) {
        return false;
    }

    private KubernetesRetriever$() {
        MODULE$ = this;
        org.apache.streampark.common.util.Logger.$init$((org.apache.streampark.common.util.Logger)this);
        this.FLINK_CLIENT_TIMEOUT_SEC = 30L;
        this.FLINK_REST_AWAIT_TIMEOUT_SEC = 10L;
        this.FLINK_REST_RETRY_MAX_ATTEMPTS = 2;
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }
}

