/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.CollectionElementFacetBuilder;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.builders.ElementFacets;
import springfox.documentation.builders.EnumerationElementFacetBuilder;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.StringElementFacetBuilder;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.NumericElementFacetBuilder;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.SimpleParameterSpecification;

public class SimpleParameterSpecificationBuilder {
    private final Map<Class<?>, ElementFacetBuilder> facetBuilders = new HashMap();
    private ParameterStyle style;
    private Boolean explode;
    private Boolean allowReserved;
    private Boolean allowEmptyValue;
    private String defaultValue;
    private CollectionFormat collectionFormat;
    private final ModelSpecificationBuilder model = new ModelSpecificationBuilder();

    public SimpleParameterSpecificationBuilder style(ParameterStyle style) {
        this.style = style;
        return this;
    }

    public SimpleParameterSpecificationBuilder explode(Boolean explode) {
        this.explode = BuilderDefaults.defaultIfAbsent(Boolean.TRUE.equals(explode) ? Boolean.valueOf(true) : null, this.explode);
        return this;
    }

    public SimpleParameterSpecificationBuilder allowReserved(Boolean allowReserved) {
        this.allowReserved = BuilderDefaults.defaultIfAbsent(allowReserved, this.allowReserved);
        return this;
    }

    public SimpleParameterSpecificationBuilder model(@NonNull Consumer<ModelSpecificationBuilder> consumer) {
        consumer.accept(this.model);
        return this;
    }

    public SimpleParameterSpecificationBuilder allowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = BuilderDefaults.defaultIfAbsent(Boolean.TRUE.equals(allowEmptyValue) ? Boolean.valueOf(true) : null, this.allowEmptyValue);
        return this;
    }

    public SimpleParameterSpecificationBuilder defaultValue(String defaultValue) {
        this.defaultValue = BuilderDefaults.defaultIfAbsent(BuilderDefaults.emptyToNull(defaultValue), this.defaultValue);
        return this;
    }

    @Deprecated
    public SimpleParameterSpecificationBuilder collectionFormat(CollectionFormat collectionFormat) {
        this.collectionFormat = collectionFormat;
        return this;
    }

    private <T extends ElementFacetBuilder> T facetBuilder(Class<T> clazz) {
        this.facetBuilders.computeIfAbsent(clazz, ElementFacets.builderFactory(clazz));
        return (T)this.facetBuilders.get(clazz);
    }

    public SimpleParameterSpecificationBuilder collectionFacet(@NonNull Consumer<CollectionElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(CollectionElementFacetBuilder.class));
        return this;
    }

    public SimpleParameterSpecificationBuilder stringFacet(@NonNull Consumer<StringElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(StringElementFacetBuilder.class));
        return this;
    }

    public SimpleParameterSpecificationBuilder numericFacet(@NonNull Consumer<NumericElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(NumericElementFacetBuilder.class));
        return this;
    }

    public SimpleParameterSpecificationBuilder enumerationFacet(@NonNull Consumer<EnumerationElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(EnumerationElementFacetBuilder.class));
        return this;
    }

    public SimpleParameterSpecificationBuilder copyOf(SimpleParameterSpecification other) {
        for (ElementFacet each : other.getFacets()) {
            this.facetBuilder(each.facetBuilder()).copyOf(each);
        }
        return this.collectionFormat(other.getCollectionFormat()).allowEmptyValue(other.getAllowEmptyValue()).allowReserved(other.getAllowReserved()).defaultValue(other.getDefaultValue()).explode(other.getExplode()).model(m -> m.copyOf(other.getModel())).style(other.getStyle());
    }

    SimpleParameterSpecification build() {
        ModelSpecification builtModel = this.model.build();
        if (builtModel == null) {
            return null;
        }
        List<ElementFacet> facets = this.facetBuilders.values().stream().filter(Objects::nonNull).map(ElementFacetBuilder::build).filter(Objects::nonNull).collect(Collectors.toList());
        return new SimpleParameterSpecification(this.style, this.collectionFormat, this.explode, this.allowReserved, this.allowEmptyValue, this.defaultValue, builtModel, facets);
    }
}

