/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.listener;

import java.io.File;
import org.sonatype.aether.transfer.TransferResource;

public class DefaultTransferResource
implements TransferResource {
    private final String repositoryUrl;
    private final String resourceName;
    private final File file;
    private final long startTime;
    private long contentLength = -1L;

    public DefaultTransferResource(String repositoryUrl, String resourceName, File file) {
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.length() <= 0 ? "" : (repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.length() <= 0 ? "" : (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.file = file;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public DefaultTransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public long getTransferStartTime() {
        return this.startTime;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + " <> " + this.getFile();
    }
}

