/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.util.ShaHashUtils;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.mapper.UserMapper;
import org.apache.streampark.console.system.service.MemberService;
import org.apache.streampark.console.system.service.MenuService;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private MemberService memberService;
    @Autowired
    private MenuService menuService;

    @Override
    public User findByName(String username) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getUsername, (Object)username);
        return (User)((UserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public IPage<User> findUserDetail(User user, RestRequest request) {
        Page page = new Page();
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        IPage<User> resPage = ((UserMapper)this.baseMapper).findUserDetail(page, user);
        Utils.required((resPage != null ? 1 : 0) != 0);
        if (resPage.getTotal() == 0L) {
            resPage.setRecords(Collections.emptyList());
        }
        return resPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateLoginTime(String username) {
        User user = new User();
        user.setLastLoginTime(new Date());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getUsername, (Object)username);
        ((UserMapper)this.baseMapper).update(user, (Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createUser(User user) {
        user.setCreateTime(new Date());
        user.setAvatar("default.jpg");
        String salt = ShaHashUtils.getRandomSalt();
        String password = ShaHashUtils.encrypt(salt, user.getPassword());
        user.setSalt(salt);
        user.setPassword(password);
        this.save(user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUser(User user) {
        user.setPassword(null);
        user.setModifyTime(new Date());
        this.updateById(user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUser(Long userId) {
        this.removeById(userId);
        this.memberService.deleteByUserId(userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateProfile(User user) {
        this.updateById(user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAvatar(String username, String avatar) {
        User user = new User();
        user.setAvatar(avatar);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getUsername, (Object)username);
        ((UserMapper)this.baseMapper).update(user, (Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePassword(User userParam) {
        User user = (User)this.getById(userParam.getUserId());
        if (user == null) {
            throw new ApiAlertException("update password failed, user is null");
        }
        String saltPassword = ShaHashUtils.encrypt(user.getSalt(), userParam.getOldPassword());
        if (!StringUtils.equals((CharSequence)user.getPassword(), (CharSequence)saltPassword)) {
            throw new ApiAlertException("update password failed, old password error");
        }
        String salt = ShaHashUtils.getRandomSalt();
        String password = ShaHashUtils.encrypt(salt, userParam.getPassword());
        user.setSalt(salt);
        user.setPassword(password);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getUserId, (Object)user.getUserId());
        ((UserMapper)this.baseMapper).update(user, (Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetPassword(String[] usernames) {
        for (String username : usernames) {
            User user = new User();
            String salt = ShaHashUtils.getRandomSalt();
            String password = ShaHashUtils.encrypt(salt, "streampark666");
            user.setSalt(salt);
            user.setPassword(password);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getUsername, (Object)username);
            ((UserMapper)this.baseMapper).update(user, (Wrapper)queryWrapper);
        }
    }

    @Override
    public Set<String> getPermissions(Long userId, @Nullable Long teamId) {
        List<String> userPermissions = this.menuService.findUserPermissions(userId, teamId);
        return new HashSet<String>(userPermissions);
    }

    @Override
    public List<User> getNoTokenUser() {
        List<User> users = ((UserMapper)this.baseMapper).getNoTokenUser();
        if (!users.isEmpty()) {
            users.forEach(User::dataMasking);
        }
        return users;
    }

    @Override
    public void setLastTeam(Long teamId, Long userId) {
        User user = (User)this.getById(userId);
        Utils.required((user != null ? 1 : 0) != 0);
        user.setLastTeamId(teamId);
        ((UserMapper)this.baseMapper).updateById(user);
    }

    @Override
    public void clearLastTeam(Long userId, Long teamId) {
        User user = (User)this.getById(userId);
        Utils.required((user != null ? 1 : 0) != 0);
        if (!teamId.equals(user.getLastTeamId())) {
            return;
        }
        ((UserMapper)this.baseMapper).clearLastTeamByUserId(userId);
    }

    @Override
    public void clearLastTeam(Long teamId) {
        ((UserMapper)this.baseMapper).clearLastTeamByTeamId(teamId);
    }

    @Override
    public void fillInTeam(User user) {
        if (user.getLastTeamId() == null) {
            List<Team> teams = this.memberService.findUserTeams(user.getUserId());
            if (CollectionUtils.isEmpty(teams)) {
                throw new ApiAlertException("The current user not belong to any team, please contact the administrator!");
            }
            if (teams.size() == 1) {
                Team team = teams.get(0);
                user.setLastTeamId(team.getId());
                ((UserMapper)this.baseMapper).updateById(user);
            }
        }
    }

    @Override
    public List<User> findByAppOwner(Long teamId) {
        return ((UserMapper)this.baseMapper).findByAppOwner(teamId);
    }

    @Override
    public Map<String, Object> generateFrontendUserInfo(User user, Long teamId, JWTToken token) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>(8);
        if (token != null) {
            userInfo.put("token", token.getToken());
            userInfo.put("expire", token.getExpireAt());
        }
        user.dataMasking();
        userInfo.put("user", user);
        Set<String> permissions = this.getPermissions(user.getUserId(), teamId);
        userInfo.put("permissions", permissions);
        return userInfo;
    }
}

