/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.mapper.ApplicationLogMapper;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ApplicationLogServiceImpl
extends ServiceImpl<ApplicationLogMapper, ApplicationLog>
implements ApplicationLogService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLogServiceImpl.class);

    @Override
    public IPage<ApplicationLog> page(ApplicationLog applicationLog, RestRequest request) {
        Page page = new MybatisPager().getPage(request, "option_time", "desc");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationLog::getAppId, (Object)applicationLog.getAppId());
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void removeApp(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationLog::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
    }
}

