/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.bean.AppBuildDockerResolvedDetail;
import org.apache.streampark.console.core.entity.AppBuildPipeline;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.flink.packer.pipeline.DockerResolvedSnapshot;
import org.apache.streampark.flink.packer.pipeline.PipelineType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"FLINK_APPLICATION_BUILD_PIPELINE_TAG"})
@Validated
@RestController
@RequestMapping(value={"flink/pipe"})
public class ApplicationBuildPipelineController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBuildPipelineController.class);
    @Autowired
    private AppBuildPipeService appBuildPipeService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkSqlService flinkSqlService;

    @ApiAccess
    @ApiOperation(value="Launch application", notes="Launch application", tags={"FLINK_APPLICATION_OPERATION_TAG"}, consumes="application/x-www-form-urlencoded")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="APP_ID", required=true, paramType="query", dataTypeClass=Long.class), @ApiImplicitParam(name="forceBuild", value="FORCE_BUILD", required=true, paramType="query", dataTypeClass=Boolean.class, defaultValue="false")})
    @PostMapping(value={"build"}, consumes={"application/x-www-form-urlencoded"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse buildApplication(Long appId, boolean forceBuild) {
        try {
            Application app = (Application)this.applicationService.getById(appId);
            boolean envOk = this.applicationService.checkEnv(app);
            if (!envOk) {
                throw new ApiAlertException("Check flink env failed, please check the flink version of this job");
            }
            if (!forceBuild && !this.appBuildPipeService.allowToBuildNow(appId)) {
                throw new ApiAlertException("The job is invalid, or the job cannot be built while it is running");
            }
            boolean needBuild = this.applicationService.checkBuildAndUpdate(app);
            if (!needBuild) {
                return RestResponse.success(true);
            }
            if (app.isNeedRollback() && app.isFlinkSqlJob()) {
                this.flinkSqlService.rollback(app);
            }
            boolean actionResult = this.appBuildPipeService.buildApplication(app);
            return RestResponse.success(actionResult);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }

    @ApiAccess
    @PostMapping(value={"/detail"})
    @RequiresPermissions(value={"app:view"})
    public RestResponse getBuildProgressDetail(Long appId) {
        HashMap<String, AppBuildDockerResolvedDetail> details = new HashMap<String, AppBuildDockerResolvedDetail>(0);
        Optional<AppBuildPipeline> pipeline = this.appBuildPipeService.getCurrentBuildPipeline(appId);
        details.put("pipeline", pipeline.map(AppBuildPipeline::toView).orElse(null));
        if (pipeline.isPresent() && PipelineType.FLINK_NATIVE_K8S_APPLICATION == pipeline.get().getPipeType()) {
            DockerResolvedSnapshot dockerProgress = this.appBuildPipeService.getDockerProgressDetailSnapshot(appId);
            details.put("docker", AppBuildDockerResolvedDetail.of(dockerProgress));
        }
        return RestResponse.success(details);
    }
}

