/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.NumericSummaryAggregator;

@Internal
public class ShortSummaryAggregator
extends NumericSummaryAggregator<Short> {
    private static final long serialVersionUID = 1L;

    public static Short min(Short a, Short b) {
        return a <= b ? a : b;
    }

    public static Short max(Short a, Short b) {
        return a >= b ? a : b;
    }

    @Override
    protected Aggregator<Short, Short> initMin() {
        return new MinShortAggregator();
    }

    @Override
    protected Aggregator<Short, Short> initMax() {
        return new MaxShortAggregator();
    }

    @Override
    protected Aggregator<Short, Short> initSum() {
        return new SumShortAggregator();
    }

    @Override
    protected boolean isNan(Short number) {
        return false;
    }

    @Override
    protected boolean isInfinite(Short number) {
        return false;
    }

    public static class SumShortAggregator
    implements Aggregator<Short, Short> {
        private short sum = 0;

        @Override
        public void aggregate(Short value) {
            this.sum = (short)(this.sum + value);
        }

        @Override
        public void combine(Aggregator<Short, Short> other) {
            this.sum = (short)(this.sum + ((SumShortAggregator)other).sum);
        }

        @Override
        public Short result() {
            return this.sum;
        }
    }

    public static class MaxShortAggregator
    implements Aggregator<Short, Short> {
        private short max = Short.MIN_VALUE;

        @Override
        public void aggregate(Short value) {
            this.max = ShortSummaryAggregator.max(this.max, value);
        }

        @Override
        public void combine(Aggregator<Short, Short> other) {
            this.max = ShortSummaryAggregator.max(this.max, ((MaxShortAggregator)other).max);
        }

        @Override
        public Short result() {
            return this.max;
        }
    }

    public static class MinShortAggregator
    implements Aggregator<Short, Short> {
        private short min = Short.MAX_VALUE;

        @Override
        public void aggregate(Short value) {
            this.min = ShortSummaryAggregator.min(this.min, value);
        }

        @Override
        public void combine(Aggregator<Short, Short> other) {
            this.min = ShortSummaryAggregator.min(this.min, ((MinShortAggregator)other).min);
        }

        @Override
        public Short result() {
            return this.min;
        }
    }
}

