/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.CredentialBasedAccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConfCredentialBasedAccessTokenProvider
extends CredentialBasedAccessTokenProvider {
    private String credential;

    public ConfCredentialBasedAccessTokenProvider() {
    }

    public ConfCredentialBasedAccessTokenProvider(Timer timer) {
        super(timer);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.credential = Utils.notNull(conf, "dfs.webhdfs.oauth2.credential");
    }

    @Override
    public String getCredential() {
        if (this.credential == null) {
            throw new IllegalArgumentException("Credential has not been provided in configuration");
        }
        return this.credential;
    }
}

