/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationHttpMethodReader
implements OperationBuilderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationHttpMethodReader.class);

    public void apply(OperationContext context) {
        Optional apiOperationAnnotation = context.findAnnotation(ApiOperation.class);
        if (apiOperationAnnotation.isPresent() && StringUtils.hasText((String)((ApiOperation)apiOperationAnnotation.get()).httpMethod())) {
            String apiMethod = ((ApiOperation)apiOperationAnnotation.get()).httpMethod();
            try {
                RequestMethod.valueOf((String)apiMethod);
                context.operationBuilder().method(HttpMethod.valueOf((String)apiMethod));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid http method: " + apiMethod + "Valid ones are [" + RequestMethod.values() + "]", (Throwable)e);
            }
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

