/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderElectionException;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperLeaderElectionDriver
implements LeaderElectionDriver,
LeaderLatchListener,
UnhandledErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLeaderElectionDriver.class);
    private final CuratorFramework client;
    private final LeaderLatch leaderLatch;
    private final TreeCache cache;
    private final String connectionInformationPath;
    private final String leaderLatchPath;
    private final ConnectionStateListener listener = (client, newState) -> this.handleStateChange(newState);
    private final LeaderElectionEventHandler leaderElectionEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private final String leaderContenderDescription;
    private volatile boolean running;

    public ZooKeeperLeaderElectionDriver(CuratorFramework client2, String path, LeaderElectionEventHandler leaderElectionEventHandler, FatalErrorHandler fatalErrorHandler, String leaderContenderDescription) throws Exception {
        Preconditions.checkNotNull((Object)path);
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client2);
        this.connectionInformationPath = ZooKeeperUtils.generateConnectionInformationPath(path);
        this.leaderElectionEventHandler = (LeaderElectionEventHandler)Preconditions.checkNotNull((Object)leaderElectionEventHandler);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.leaderContenderDescription = (String)Preconditions.checkNotNull((Object)leaderContenderDescription);
        this.leaderLatchPath = ZooKeeperUtils.generateLeaderLatchPath(path);
        this.leaderLatch = new LeaderLatch(client2, this.leaderLatchPath);
        this.cache = ZooKeeperUtils.createTreeCache(client2, this.connectionInformationPath, this::retrieveLeaderInformationFromZooKeeper);
        client2.getUnhandledErrorListenable().addListener((Object)this);
        this.running = true;
        this.leaderLatch.addListener((LeaderLatchListener)this);
        this.leaderLatch.start();
        this.cache.start();
        client2.getConnectionStateListenable().addListener((Object)this.listener);
    }

    @Override
    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Closing {}", (Object)this);
        this.client.getUnhandledErrorListenable().removeListener((Object)this);
        this.client.getConnectionStateListenable().removeListener((Object)this.listener);
        Exception exception = null;
        try {
            this.cache.close();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        if (exception != null) {
            throw new Exception("Could not properly stop the ZooKeeperLeaderElectionDriver.", exception);
        }
    }

    @Override
    public boolean hasLeadership() {
        assert (this.running);
        return this.leaderLatch.hasLeadership();
    }

    public void isLeader() {
        this.leaderElectionEventHandler.onGrantLeadership();
    }

    public void notLeader() {
        this.leaderElectionEventHandler.onRevokeLeadership();
    }

    private void retrieveLeaderInformationFromZooKeeper() throws Exception {
        if (this.leaderLatch.hasLeadership()) {
            byte[] data;
            ChildData childData = this.cache.getCurrentData(this.connectionInformationPath);
            if (childData != null && (data = childData.getData()) != null && data.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                String leaderAddress = ois.readUTF();
                UUID leaderSessionID = (UUID)ois.readObject();
                this.leaderElectionEventHandler.onLeaderInformationChange(LeaderInformation.known(leaderSessionID, leaderAddress));
                return;
            }
            this.leaderElectionEventHandler.onLeaderInformationChange(LeaderInformation.empty());
        }
    }

    @Override
    public void writeLeaderInformation(LeaderInformation leaderInformation) {
        assert (this.running);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write leader information: {}.", (Object)leaderInformation);
        }
        if (leaderInformation.isEmpty()) {
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeUTF(leaderInformation.getLeaderAddress());
            oos.writeObject(leaderInformation.getLeaderSessionID());
            oos.close();
            boolean dataWritten = false;
            while (!dataWritten && this.leaderLatch.hasLeadership()) {
                Stat stat = (Stat)this.client.checkExists().forPath(this.connectionInformationPath);
                if (stat != null) {
                    long sessionID;
                    long owner = stat.getEphemeralOwner();
                    if (owner == (sessionID = this.client.getZookeeperClient().getZooKeeper().getSessionId())) {
                        try {
                            this.client.setData().forPath(this.connectionInformationPath, baos.toByteArray());
                            dataWritten = true;
                        }
                        catch (KeeperException.NoNodeException noNodeException) {}
                        continue;
                    }
                    try {
                        this.client.delete().forPath(this.connectionInformationPath);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    continue;
                }
                try {
                    ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.connectionInformationPath, baos.toByteArray());
                    dataWritten = true;
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {}
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully wrote leader information: {}.", (Object)leaderInformation);
            }
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderElectionException("Could not write leader address and leader session ID to ZooKeeper.", e)));
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case CONNECTED: {
                LOG.debug("Connected to ZooKeeper quorum. Leader election can start.");
                break;
            }
            case SUSPENDED: {
                LOG.warn("Connection to ZooKeeper suspended, waiting for reconnection.");
                break;
            }
            case RECONNECTED: {
                LOG.info("Connection to ZooKeeper was reconnected. Leader election can be restarted.");
                break;
            }
            case LOST: {
                LOG.warn("Connection to ZooKeeper lost. The contender " + this.leaderContenderDescription + " no longer participates in the leader election.");
            }
        }
    }

    public void unhandledError(String message, Throwable e) {
        this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderElectionException("Unhandled error in ZooKeeperLeaderElectionDriver: " + message, e)));
    }

    public String toString() {
        return String.format("%s{leaderLatchPath='%s', connectionInformationPath='%s'}", this.getClass().getSimpleName(), this.leaderLatchPath, this.connectionInformationPath);
    }

    @VisibleForTesting
    String getConnectionInformationPath() {
        return this.connectionInformationPath;
    }
}

