/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.topology.ResultID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class IntermediateResultPartitionID
implements ResultID {
    private static final long serialVersionUID = 1L;
    private static final int BYTEBUF_LEN = 20;
    private final IntermediateDataSetID intermediateDataSetID;
    private final int partitionNum;

    @VisibleForTesting
    public IntermediateResultPartitionID() {
        this.partitionNum = -1;
        this.intermediateDataSetID = new IntermediateDataSetID();
    }

    public IntermediateResultPartitionID(IntermediateDataSetID intermediateDataSetID, int partitionNum) {
        this.intermediateDataSetID = intermediateDataSetID;
        this.partitionNum = partitionNum;
    }

    public int getPartitionNumber() {
        return this.partitionNum;
    }

    public IntermediateDataSetID getIntermediateDataSetID() {
        return this.intermediateDataSetID;
    }

    public void writeTo(ByteBuf buf) {
        this.intermediateDataSetID.writeTo(buf);
        buf.writeInt(this.partitionNum);
    }

    public static IntermediateResultPartitionID fromByteBuf(ByteBuf buf) {
        IntermediateDataSetID intermediateDataSetID = IntermediateDataSetID.fromByteBuf(buf);
        int partitionNum = buf.readInt();
        return new IntermediateResultPartitionID(intermediateDataSetID, partitionNum);
    }

    public static int getByteBufLength() {
        return 20;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IntermediateResultPartitionID that = (IntermediateResultPartitionID)obj;
            return that.intermediateDataSetID.equals(this.intermediateDataSetID) && that.partitionNum == this.partitionNum;
        }
        return false;
    }

    public int hashCode() {
        return this.intermediateDataSetID.hashCode() ^ this.partitionNum;
    }

    public String toString() {
        return this.intermediateDataSetID.toString() + "#" + this.partitionNum;
    }
}

