/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferConsumerWithPartialRecordLength {
    private final BufferConsumer bufferConsumer;
    private final int partialRecordLength;

    public BufferConsumerWithPartialRecordLength(BufferConsumer bufferConsumer, int partialRecordLength) {
        this.bufferConsumer = (BufferConsumer)Preconditions.checkNotNull((Object)bufferConsumer);
        this.partialRecordLength = partialRecordLength;
    }

    public BufferConsumer getBufferConsumer() {
        return this.bufferConsumer;
    }

    public int getPartialRecordLength() {
        return this.partialRecordLength;
    }

    public Buffer build() {
        return this.bufferConsumer.build();
    }

    public boolean cleanupPartialRecord() {
        Preconditions.checkState((this.partialRecordLength >= 0 ? 1 : 0) != 0, (Object)"Approximate local recovery does not yet work with unaligned checkpoint!");
        if (this.partialRecordLength == 0 || !this.bufferConsumer.isStartOfDataBuffer()) {
            return true;
        }
        Preconditions.checkState((this.partialRecordLength <= this.bufferConsumer.getBufferSize() ? 1 : 0) != 0, (Object)"Partial record length beyond max buffer capacity!");
        this.bufferConsumer.skip(this.partialRecordLength);
        return this.partialRecordLength < this.bufferConsumer.getBufferSize();
    }
}

