/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.LocalDateComparator;
import org.apache.flink.api.common.typeutils.base.LocalTimeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class LocalDateTimeComparator
extends TypeComparator<LocalDateTime>
implements Serializable {
    private transient LocalDateTime reference;
    protected final boolean ascendingComparison;
    protected final LocalDateComparator dateComparator;
    protected final LocalTimeComparator timeComparator;
    private final LocalDateTimeComparator[] comparators = new LocalDateTimeComparator[]{this};

    public LocalDateTimeComparator(boolean ascending) {
        this.ascendingComparison = ascending;
        this.dateComparator = new LocalDateComparator(ascending);
        this.timeComparator = new LocalTimeComparator(ascending);
    }

    @Override
    public int hash(LocalDateTime value) {
        return value.hashCode();
    }

    @Override
    public void setReference(LocalDateTime toCompare) {
        this.reference = toCompare;
    }

    @Override
    public boolean equalToReference(LocalDateTime candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<LocalDateTime> referencedComparator) {
        int comp = ((LocalDateTimeComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(LocalDateTime first, LocalDateTime second) {
        int cmp = first.compareTo(second);
        return this.ascendingComparison ? cmp : -cmp;
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(LocalDateTime record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public LocalDateTime readWithKeyDenormalization(LocalDateTime reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int cmp = this.dateComparator.compareSerialized(firstSource, secondSource);
        if (cmp == 0) {
            cmp = this.timeComparator.compareSerialized(firstSource, secondSource);
        }
        return cmp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.dateComparator.getNormalizeKeyLen() + this.timeComparator.getNormalizeKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(LocalDateTime record, MemorySegment target, int offset, int numBytes) {
        int dateNKLen = this.dateComparator.getNormalizeKeyLen();
        if (numBytes <= dateNKLen) {
            this.dateComparator.putNormalizedKey(record.toLocalDate(), target, offset, numBytes);
        } else {
            this.dateComparator.putNormalizedKey(record.toLocalDate(), target, offset, dateNKLen);
            this.timeComparator.putNormalizedKey(record.toLocalTime(), target, offset + dateNKLen, numBytes - dateNKLen);
        }
    }

    public LocalDateTimeComparator duplicate() {
        return new LocalDateTimeComparator(this.ascendingComparison);
    }
}

