/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.util.Logger;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public final class PropertiesUtils$
implements Logger {
    public static PropertiesUtils$ MODULE$;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new PropertiesUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String readFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("[StreamPark] readFile: file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("[StreamPark] readFile: file ").append(file).append(" is not a normal file").toString());
        Scanner scanner = new Scanner(file);
        scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();
        while (scanner.hasNextLine()) {
            buffer.append(scanner.nextLine()).append("\r\n");
        }
        scanner.close();
        return buffer.toString();
    }

    private Map<String, String> eachAppendYamlItem(String prefix, String k, Object v, scala.collection.mutable.Map<String, String> proper) {
        Map map;
        Object object = v;
        if (object instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)linkedHashMap).flatMap((Function1 & Serializable & scala.Serializable)x -> {
                String string = prefix;
                Map<String, String> map = "".equals(string) ? MODULE$.eachAppendYamlItem(k, (String)x._1(), x._2(), proper) : MODULE$.eachAppendYamlItem(new StringBuilder(1).append(string).append(".").append(k).toString(), (String)x._1(), x._2(), proper);
                return map;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            Object object2 = object;
            String string = object2 == null ? "" : object2.toString();
            String value = string;
            String string2 = prefix;
            scala.collection.mutable.Map map2 = "".equals(string2) ? (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)value)) : (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(string2).append(".").append(k).toString()), (Object)value));
            map = proper.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public Map<String, String> fromYamlText(String text) {
        Map map;
        try {
            scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)new Yaml().load(text)).flatMap((Function1 & Serializable & scala.Serializable)x -> MODULE$.eachAppendYamlItem("", (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)map2), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading conf error:", e);
        }
        return map;
    }

    public Map<String, String> fromHoconText(String conf) {
        Map<String, String> map;
        Predef$.MODULE$.require(conf != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromHoconText: Hocon content must not be null");
        try {
            map = this.parseHoconByReader(new StringReader(conf));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    public Map<String, String> fromPropertiesText(String conf) {
        Map map;
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(conf));
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(properties.stringPropertyNames()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading properties ", e);
        }
        return map;
    }

    public Map<String, String> fromYamlFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("[StreamPark] fromYamlFile: Yaml file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("[StreamPark] fromYamlFile: Yaml file ").append(file).append(" is not a normal file").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromYamlFile(inputStream);
    }

    public Map<String, String> fromHoconFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("[StreamPark] fromHoconFile: file ").append(file).append(" does not exist").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromHoconFile(inputStream);
    }

    public Map<String, String> fromPropertiesFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("[StreamPark] fromPropertiesFile: Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("[StreamPark] fromPropertiesFile: Properties file ").append(file).append(" is not a normal file").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromPropertiesFile(inputStream);
    }

    public Map<String, String> fromYamlFile(InputStream inputStream) {
        Map map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromYamlFile: Properties inputStream  must not be null");
        try {
            try {
                scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)new Yaml().load(inputStream)).flatMap((Function1 & Serializable & scala.Serializable)x -> MODULE$.eachAppendYamlItem("", (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)map2), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed when loading yaml from inputStream", e);
            }
        }
        finally {
            inputStream.close();
        }
        return map;
    }

    public Map<String, String> fromHoconFile(InputStream inputStream) {
        Map<String, String> map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromHoconFile: Hocon inputStream  must not be null");
        try {
            map = this.parseHoconByReader(new InputStreamReader(inputStream));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    private Map<String, String> parseHoconByReader(Reader reader) {
        Map map;
        try {
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(ConfigFactory.parseReader(reader).entrySet()).map((Function1 & Serializable & scala.Serializable)x -> {
                String k = ((String)x.getKey()).trim().replaceAll("\"", "");
                String v = ((ConfigValue)x.getValue()).unwrapped().toString().trim();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    public Map<String, String> fromPropertiesFile(InputStream inputStream) {
        Map map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromPropertiesFile: Properties inputStream  must not be null");
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(properties.stringPropertyNames()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("[StreamPark] Failed when loading properties from inputStream", e);
        }
        return map;
    }

    public HashMap<String, String> fromYamlTextAsJava(String text) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlText(text)).asJava());
    }

    public HashMap<String, String> fromHoconTextAsJava(String text) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconText(text)).asJava());
    }

    public HashMap<String, String> fromPropertiesTextAsJava(String text) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesText(text)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(String filename) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(filename)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(String filename) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(filename)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(String filename) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(filename)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(inputStream)).asJava());
    }

    public HashMap<String, String> loadFlinkConfYaml(File file) {
        Predef$.MODULE$.require(file != null && file.exists() && file.isFile(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] loadFlinkConfYaml: file must not be null");
        return this.loadFlinkConfYaml(FileUtils.readFileToString((File)file));
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, String> loadFlinkConfYaml(String yaml) {
        void var2_2;
        Predef$.MODULE$.require(yaml != null && new StringOps(Predef$.MODULE$.augmentString(yaml)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] loadFlinkConfYaml: yaml must not be null");
        HashMap flinkConf = new HashMap();
        Scanner scanner = new Scanner(yaml);
        AtomicInteger lineNo = new AtomicInteger(0);
        while (scanner.hasNextLine()) {
            BoxedUnit boxedUnit;
            String line = scanner.nextLine();
            lineNo.incrementAndGet();
            String[] comments = line.split("^#|\\s+#", 2);
            String conf = comments[0].trim();
            if (new StringOps(Predef$.MODULE$.augmentString(conf)).nonEmpty()) {
                String[] kv = conf.split(": ", 2);
                if (kv.length == 2) {
                    String key = kv[0].trim();
                    String value = kv[1].trim();
                    if (new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty()) {
                        boxedUnit = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(flinkConf).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
                        continue;
                    }
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Error after splitting key and value in configuration ").append(lineNo.get()).append(": ").append(line).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Error while trying to split key and value in configuration. ").append(lineNo).append(" : ").append(line).toString());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private PropertiesUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

