/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.conf;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.streampark.common.util.CommandUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A\u0001E\t\u00019!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00034\u0011\u0015y\u0004\u0001\"\u0001A\u0011!!\u0005\u0001#b!\n\u0013)\u0005\u0002C'\u0001\u0011\u000b\u0007K\u0011B#\t\u00119\u0003\u0001R1Q\u0005\n\u0015C\u0001b\u0014\u0001\t\u0006\u0004%\tA\r\u0005\t!\u0002A)\u0019!C\u0001e!A\u0011\u000b\u0001EC\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001!\u0015\r\u0011\"\u0001X\u0011!9\u0007\u0001#b\u0001\n\u0003\u0011\u0004\u0002\u00035\u0001\u0011\u000b\u0007I\u0011\u0001\u001a\t\u0011%\u0004\u0001R1A\u0005\u0002IC\u0001B\u001b\u0001\t\u0006\u0004%\tA\r\u0005\u0006W\u0002!\t\u0005\u001c\u0002\r\r2Lgn\u001b,feNLwN\u001c\u0006\u0003%M\tAaY8oM*\u0011A#F\u0001\u0007G>lWn\u001c8\u000b\u0005Y9\u0012AC:ue\u0016\fW\u000e]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000f$WA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0005%|'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001L\u0018\u000e\u00035R!AL\n\u0002\tU$\u0018\u000e\\\u0005\u0003a5\u0012a\u0001T8hO\u0016\u0014\u0018!\u00034mS:\\\u0007j\\7f+\u0005\u0019\u0004C\u0001\u001b<\u001d\t)\u0014\b\u0005\u00027?5\tqG\u0003\u000297\u00051AH]8pizJ!AO\u0010\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u}\t!B\u001a7j].Du.\\3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011i\u0011\t\u0003\u0005\u0002i\u0011!\u0005\u0005\u0006c\r\u0001\raM\u0001\u0012\r2KejS0W\u000bJ{\u0006+\u0011+U\u000bJsU#\u0001$\u0011\u0005\u001d[U\"\u0001%\u000b\u0005%S\u0015!\u0002:fO\u0016D(B\u0001\u0018(\u0013\ta\u0005JA\u0004QCR$XM\u001d8\u0002+\u0019c\u0015JT&`-\u0016\u00136+S(O?B\u000bE\u000bV#S\u001d\u0006Yb\tT%O\u0017~\u001b6)\u0011'B?Z+%kU%P\u001d~\u0003\u0016\t\u0016+F%:\u000bAb]2bY\u00064VM]:j_:\f1BZ;mYZ+'o]5p]\u0006Aa\r\\5oW2K'-F\u0001T!\t!C+\u0003\u0002VK\t!a)\u001b7f\u0003%1G.\u001b8l\u0019&\u00147/F\u0001Y!\rIf,\u0019\b\u00035rs!AN.\n\u0003\u0001J!!X\u0010\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\u0005\u0019&\u001cHO\u0003\u0002^?A\u0011!-Z\u0007\u0002G*\u0011AmJ\u0001\u0004]\u0016$\u0018B\u00014d\u0005\r)&\u000bT\u0001\bm\u0016\u00148/[8o\u00031i\u0017M[8s-\u0016\u00148/[8o\u000311G.\u001b8l\t&\u001cHOS1s\u00031\u0019\b.[7t-\u0016\u00148/[8o\u0003!!xn\u0015;sS:<G#A\u001a")
public class FlinkVersion
implements Serializable,
org.apache.streampark.common.util.Logger {
    private Pattern FLINK_VER_PATTERN;
    private Pattern org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    private Pattern FLINK_SCALA_VERSION_PATTERN;
    private String scalaVersion;
    private String fullVersion;
    private File flinkLib;
    private List<URL> flinkLibs;
    private String version;
    private String majorVersion;
    private File flinkDistJar;
    private String shimsVersion;
    private final String flinkHome;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile int bitmap$0;

    @Override
    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$(this);
    }

    @Override
    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String flinkHome() {
        return this.flinkHome;
    }

    private Pattern FLINK_VER_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 1) == 0) {
                this.FLINK_VER_PATTERN = Pattern.compile("^(\\d+\\.\\d+)(\\.)?.*$");
                this.bitmap$0 |= 1;
            }
        }
        return this.FLINK_VER_PATTERN;
    }

    private Pattern FLINK_VER_PATTERN() {
        return (this.bitmap$0 & 1) == 0 ? this.FLINK_VER_PATTERN$lzycompute() : this.FLINK_VER_PATTERN;
    }

    private Pattern FLINK_VERSION_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 2) == 0) {
                this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN = Pattern.compile("^Version: (.*), Commit ID: (.*)$");
                this.bitmap$0 |= 2;
            }
        }
        return this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    }

    public Pattern org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN() {
        return (this.bitmap$0 & 2) == 0 ? this.FLINK_VERSION_PATTERN$lzycompute() : this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    }

    private Pattern FLINK_SCALA_VERSION_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 4) == 0) {
                this.FLINK_SCALA_VERSION_PATTERN = Pattern.compile("^flink-dist_(.*)-(.*).jar$");
                this.bitmap$0 |= 4;
            }
        }
        return this.FLINK_SCALA_VERSION_PATTERN;
    }

    private Pattern FLINK_SCALA_VERSION_PATTERN() {
        return (this.bitmap$0 & 4) == 0 ? this.FLINK_SCALA_VERSION_PATTERN$lzycompute() : this.FLINK_SCALA_VERSION_PATTERN;
    }

    private String scalaVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 8) == 0) {
                Matcher matcher = this.FLINK_SCALA_VERSION_PATTERN().matcher(this.flinkDistJar().getName());
                this.scalaVersion = matcher.matches() ? matcher.group(1) : "2.12";
                this.bitmap$0 |= 8;
            }
        }
        return this.scalaVersion;
    }

    public String scalaVersion() {
        return (this.bitmap$0 & 8) == 0 ? this.scalaVersion$lzycompute() : this.scalaVersion;
    }

    private String fullVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.fullVersion = new StringBuilder(1).append(this.version()).append("_").append(this.scalaVersion()).toString();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.fullVersion;
    }

    public String fullVersion() {
        return (this.bitmap$0 & 0x10) == 0 ? this.fullVersion$lzycompute() : this.fullVersion;
    }

    /*
     * WARNING - void declaration
     */
    private File flinkLib$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x20) == 0) {
                void var2_2;
                Predef$.MODULE$.require(this.flinkHome() != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] flinkHome must not be null.");
                Predef$.MODULE$.require(new File(this.flinkHome()).exists(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] flinkHome must be exists.");
                File lib = new File(new StringBuilder(4).append(this.flinkHome()).append("/lib").toString());
                Predef$.MODULE$.require(lib.exists() && lib.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("[StreamPark] ").append(this.flinkHome()).append("/lib must be exists and must be directory.").toString());
                this.flinkLib = var2_2;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.flinkLib;
    }

    public File flinkLib() {
        return (this.bitmap$0 & 0x20) == 0 ? this.flinkLib$lzycompute() : this.flinkLib;
    }

    private List<URL> flinkLibs$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.flinkLibs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.flinkLib().listFiles())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.flinkLibs;
    }

    public List<URL> flinkLibs() {
        return (this.bitmap$0 & 0x40) == 0 ? this.flinkLibs$lzycompute() : this.flinkLibs;
    }

    private String version$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x80) == 0) {
                AtomicReference flinkVersion2 = new AtomicReference();
                .colon.colon cmd = new .colon.colon((Object)new StringBuilder(66).append("java -classpath ").append(this.flinkDistJar().getAbsolutePath()).append(" org.apache.flink.client.cli.CliFrontend --version").toString(), (List)Nil$.MODULE$);
                AtomicBoolean success = new AtomicBoolean(false);
                scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();
                CommandUtils$.MODULE$.execute(this.flinkLib().getAbsolutePath(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)cmd), new Consumer<String>(this, buffer, success, flinkVersion2){
                    private final /* synthetic */ FlinkVersion $outer;
                    private final scala.collection.mutable.StringBuilder buffer$1;
                    private final AtomicBoolean success$1;
                    private final AtomicReference flinkVersion$1;

                    public Consumer<String> andThen(Consumer<? super String> x$1) {
                        return Consumer.super.andThen(x$1);
                    }

                    public void accept(String out) {
                        block0: {
                            this.buffer$1.append(out).append("\n");
                            Matcher matcher = this.$outer.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN().matcher(out);
                            if (!matcher.find()) break block0;
                            this.success$1.set(true);
                            this.flinkVersion$1.set(matcher.group(1));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer$1 = buffer$1;
                        this.success$1 = success$1;
                        this.flinkVersion$1 = flinkVersion$1;
                    }
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> buffer.toString());
                if (!success.get()) {
                    throw new IllegalStateException(new StringBuilder(41).append("[StreamPark] parse flink version failed. ").append((CharSequence)buffer).toString());
                }
                buffer.clear();
                this.version = (String)flinkVersion2.get();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.version;
    }

    public String version() {
        return (this.bitmap$0 & 0x80) == 0 ? this.version$lzycompute() : this.version;
    }

    private String majorVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x100) == 0) {
                String string;
                if (this.version() == null) {
                    string = null;
                } else {
                    Matcher matcher = this.FLINK_VER_PATTERN().matcher(this.version());
                    matcher.matches();
                    string = matcher.group(1);
                }
                this.majorVersion = string;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.majorVersion;
    }

    public String majorVersion() {
        return (this.bitmap$0 & 0x100) == 0 ? this.majorVersion$lzycompute() : this.majorVersion;
    }

    private File flinkDistJar$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x200) == 0) {
                File[] distJar = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.flinkLib().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkVersion.$anonfun$flinkDistJar$1(x$2)));
                File[] fileArray = distJar;
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileArray)).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("[StreamPark] can no found flink-dist jar in ").append(this.flinkLib()).toString());
                }
                if (fileArray.length > 1) {
                    throw new IllegalArgumentException(new StringBuilder(46).append("[StreamPark] found multiple flink-dist jar in ").append(this.flinkLib()).toString());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                this.flinkDistJar = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distJar)).head();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.flinkDistJar;
    }

    public File flinkDistJar() {
        return (this.bitmap$0 & 0x200) == 0 ? this.flinkDistJar$lzycompute() : this.flinkDistJar;
    }

    private String shimsVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.shimsVersion = new StringBuilder(29).append("streampark-flink-shims_flink-").append(this.majorVersion()).toString();
                this.bitmap$0 |= 0x400;
            }
        }
        return this.shimsVersion;
    }

    public String shimsVersion() {
        return (this.bitmap$0 & 0x400) == 0 ? this.shimsVersion$lzycompute() : this.shimsVersion;
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(383).append("\n       |----------------------------------------- flink version -----------------------------------\n       |     flinkHome    : ").append(this.flinkHome()).append("\n       |     distJarName  : ").append(this.flinkDistJar().getName()).append("\n       |     flinkVersion : ").append(this.version()).append("\n       |     majorVersion : ").append(this.majorVersion()).append("\n       |     scalaVersion : ").append(this.scalaVersion()).append("\n       |     shimsVersion : ").append(this.shimsVersion()).append("\n       |-------------------------------------------------------------------------------------------\n       |").toString())).stripMargin();
    }

    public static final /* synthetic */ boolean $anonfun$flinkDistJar$1(File x$2) {
        return x$2.getName().matches("flink-dist.*\\.jar");
    }

    public FlinkVersion(String flinkHome) {
        this.flinkHome = flinkHome;
        org.apache.streampark.common.util.Logger.$init$(this);
    }
}

