/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedArrayType;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.ScalarType;

public class ScalarTypes {
    private static final Map<Type, ScalarType> SCALAR_TYPE_LOOKUP = new HashMap<Type, ScalarType>();

    private ScalarTypes() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ScalarType> builtInScalarType(Type forType) {
        if (forType instanceof ResolvedType) {
            return ScalarTypes.builtInScalarTypeForResolvedType((ResolvedType)forType);
        }
        return Optional.ofNullable(SCALAR_TYPE_LOOKUP.get(forType));
    }

    private static Optional<ScalarType> builtInScalarTypeForResolvedType(ResolvedType forType) {
        if (forType instanceof ResolvedArrayType && (forType.getArrayElementType().getErasedType() == Byte.class || forType.getArrayElementType().getErasedType() == Byte.TYPE)) {
            return Optional.of(ScalarType.BYTE);
        }
        return Optional.ofNullable(SCALAR_TYPE_LOOKUP.get(forType.getErasedType()));
    }

    static {
        SCALAR_TYPE_LOOKUP.put(Long.TYPE, ScalarType.LONG);
        SCALAR_TYPE_LOOKUP.put(Short.TYPE, ScalarType.INTEGER);
        SCALAR_TYPE_LOOKUP.put(Integer.TYPE, ScalarType.INTEGER);
        SCALAR_TYPE_LOOKUP.put(Double.TYPE, ScalarType.DOUBLE);
        SCALAR_TYPE_LOOKUP.put(Float.TYPE, ScalarType.FLOAT);
        SCALAR_TYPE_LOOKUP.put(Byte.TYPE, ScalarType.BYTE);
        SCALAR_TYPE_LOOKUP.put(Boolean.TYPE, ScalarType.BOOLEAN);
        SCALAR_TYPE_LOOKUP.put(Character.TYPE, ScalarType.STRING);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)java.util.Date.class), ScalarType.DATE_TIME);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Date.class), ScalarType.DATE);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)String.class), ScalarType.STRING);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Long.class), ScalarType.LONG);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Short.class), ScalarType.INTEGER);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Integer.class), ScalarType.INTEGER);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Double.class), ScalarType.DOUBLE);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Float.class), ScalarType.FLOAT);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Byte.class), ScalarType.BYTE);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Boolean.class), ScalarType.BOOLEAN);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Character.class), ScalarType.STRING);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)BigDecimal.class), ScalarType.BIGDECIMAL);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)BigInteger.class), ScalarType.BIGINTEGER);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Currency.class), ScalarType.BIGDECIMAL);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)UUID.class), ScalarType.UUID);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)MultipartFile.class), ScalarType.BINARY);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)FilePart.class), ScalarType.BINARY);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)File.class), ScalarType.BINARY);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)URL.class), ScalarType.URL);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)URI.class), ScalarType.URI);
        SCALAR_TYPE_LOOKUP.put((Type)((Object)Object.class), ScalarType.OBJECT);
    }
}

