/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.configuration;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import springfox.documentation.builders.AlternateTypeBuilder;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.spring.web.OnServletBasedWebApplication;

@Configuration
@ComponentScan(basePackages={"springfox.documentation.spring.data.rest"})
@ConditionalOnWebApplication
@ConditionalOnClass(value={RepositoryRestConfiguration.class, OnServletBasedWebApplication.class})
public class SpringDataRestConfiguration {
    @Bean
    public AlternateTypeRuleConvention pageableConvention(final TypeResolver resolver, final RepositoryRestConfiguration restConfiguration) {
        return new AlternateTypeRuleConvention(){

            public int getOrder() {
                return Integer.MIN_VALUE;
            }

            public List<AlternateTypeRule> rules() {
                return Collections.singletonList(AlternateTypeRules.newRule((Type)resolver.resolve(Pageable.class, new Type[0]), (Type)resolver.resolve(SpringDataRestConfiguration.this.pageableMixin(restConfiguration), new Type[0])));
            }
        };
    }

    private Type pageableMixin(RepositoryRestConfiguration restConfiguration) {
        return new AlternateTypeBuilder().fullyQualifiedClassName(String.format("%s.generated.%s", Pageable.class.getPackage().getName(), Pageable.class.getSimpleName())).property(p -> p.name(restConfiguration.getPageParamName()).type(Integer.class).canRead(true).canWrite(true)).property(p -> p.name(restConfiguration.getLimitParamName()).type(Integer.class).canRead(true).canWrite(true)).property(p -> p.name(restConfiguration.getSortParamName()).type(String.class).canRead(true).canWrite(true)).build();
    }
}

