/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import springfox.documentation.schema.Model;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spring.web.scanners.ComparisonCondition;

public class MergingContext {
    private final String rootId;
    private final String parameterId;
    private final Map<String, Set<String>> circlePath;
    private final Map<String, Set<String>> circleParameters;
    private final Map<String, ComparisonCondition> globalComparisonConditions;
    private final Map<String, Set<Model>> typedModelMap;
    private final Map<String, String> modelIdToParameterId;
    private final Map<String, ModelContext> contextMap;
    private final Map<String, Model> currentBranch;
    private final Set<String> seenModels;

    public MergingContext(String parameterId, Map<String, Set<Model>> typedModelMap, Map<String, String> modelIdToParameterId, Map<String, Model> currentBranch, Map<String, ModelContext> contextMap) {
        this.rootId = "";
        this.parameterId = parameterId;
        this.globalComparisonConditions = new HashMap<String, ComparisonCondition>();
        this.circlePath = new HashMap<String, Set<String>>();
        this.circleParameters = new HashMap<String, Set<String>>();
        this.contextMap = Collections.unmodifiableMap(MergingContext.copyMap(contextMap));
        this.currentBranch = Collections.unmodifiableMap(MergingContext.copyMap(currentBranch));
        this.typedModelMap = Collections.unmodifiableMap(MergingContext.copyMap(typedModelMap));
        this.modelIdToParameterId = Collections.unmodifiableMap(MergingContext.copyMap(modelIdToParameterId));
        this.seenModels = new HashSet<String>();
    }

    private MergingContext(String rootId, Set<String> seenModels, MergingContext mergingContext) {
        this.rootId = rootId;
        this.parameterId = mergingContext.parameterId;
        this.circlePath = Collections.unmodifiableMap(MergingContext.copyMap(mergingContext.circlePath));
        this.circleParameters = Collections.unmodifiableMap(MergingContext.copyMap(mergingContext.circleParameters));
        this.globalComparisonConditions = Collections.unmodifiableMap(MergingContext.copyMap(mergingContext.globalComparisonConditions));
        this.contextMap = mergingContext.contextMap;
        this.currentBranch = mergingContext.currentBranch;
        this.typedModelMap = mergingContext.typedModelMap;
        this.modelIdToParameterId = mergingContext.modelIdToParameterId;
        this.seenModels = Collections.unmodifiableSet(seenModels);
    }

    private MergingContext(String rootId, Set<String> seenModels, Map<String, Set<String>> circlePath, Map<String, Set<String>> circleParameters, Map<String, ComparisonCondition> globalComparisonConditions, MergingContext mergingContext) {
        this.rootId = rootId;
        this.parameterId = mergingContext.parameterId;
        this.circlePath = Collections.unmodifiableMap(circlePath);
        this.circleParameters = Collections.unmodifiableMap(circleParameters);
        this.globalComparisonConditions = Collections.unmodifiableMap(globalComparisonConditions);
        this.contextMap = mergingContext.contextMap;
        this.currentBranch = mergingContext.currentBranch;
        this.typedModelMap = mergingContext.typedModelMap;
        this.modelIdToParameterId = mergingContext.modelIdToParameterId;
        this.seenModels = Collections.unmodifiableSet(seenModels);
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getParameterId() {
        return this.parameterId;
    }

    public Optional<ComparisonCondition> getComparisonCondition(String modelFor) {
        return Optional.ofNullable(this.globalComparisonConditions.get(modelFor));
    }

    public Map<String, Set<String>> getCircles() {
        return this.circlePath;
    }

    public Set<String> getCircleParameters(String circleId) {
        return this.circleParameters.get(circleId);
    }

    public Model getRootModel() {
        return this.currentBranch.get(this.rootId);
    }

    public boolean containsModel(String modelId) {
        return this.contextMap.containsKey(modelId);
    }

    public Model getModel(String modelId) {
        return this.currentBranch.get(modelId);
    }

    public ModelContext getModelContext(String modelId) {
        return this.contextMap.get(modelId);
    }

    public String getModelParameter(String modelId) {
        return this.modelIdToParameterId.get(modelId);
    }

    public Set<Model> getSimilarTypeModels(String type) {
        if (this.typedModelMap.containsKey(type)) {
            return this.typedModelMap.get(type);
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    public boolean hasSeenBefore(String modelId) {
        return this.seenModels.contains(modelId);
    }

    public MergingContext toRootId(String rootId, Set<ComparisonCondition> comparisonConditions, Set<String> allowedParameters) {
        HashSet<String> localSeenModels = new HashSet<String>(this.seenModels);
        localSeenModels.add(rootId);
        Map<String, ComparisonCondition> globalComparisonConditions = MergingContext.copyMap(this.globalComparisonConditions);
        comparisonConditions.forEach(condition -> globalComparisonConditions.put(condition.getModelFor(), (ComparisonCondition)condition));
        Map<String, Set<String>> circleParameters = MergingContext.copyMap(this.circleParameters);
        circleParameters.put(this.rootId, new HashSet<String>(allowedParameters));
        Map<String, Set<String>> circlePath = MergingContext.copyMap(this.circlePath);
        circlePath.forEach((k, v) -> v.add(rootId));
        circlePath.put(this.rootId, new HashSet<String>(Collections.singletonList(rootId)));
        return new MergingContext(rootId, localSeenModels, circlePath, circleParameters, globalComparisonConditions, this);
    }

    public MergingContext toRootId(String rootId) {
        HashSet<String> localSeenModels = new HashSet<String>(this.seenModels);
        localSeenModels.add(rootId);
        return new MergingContext(rootId, localSeenModels, this);
    }

    private static <k, v> Map<k, v> copyMap(Map<k, v> originalMap) {
        HashMap<k, v> newMap = new HashMap<k, v>(originalMap.size());
        newMap.putAll(originalMap);
        return newMap;
    }
}

