/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllReduceDriver<T>
implements Driver<ReduceFunction<T>, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AllReduceDriver.class);
    private TaskContext<ReduceFunction<T>, T> taskContext;
    private MutableObjectIterator<T> input;
    private TypeSerializer<T> serializer;
    private boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<ReduceFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<ReduceFunction<T>> getStubType() {
        Class<ReduceFunction> clazz = ReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.ALL_REDUCE) {
            throw new Exception("Unrecognized driver strategy for AllReduce driver: " + config.getDriverStrategy().name());
        }
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.serializer = serializerFactory.getSerializer();
        this.input = this.taskContext.getInput(0);
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("AllReduceDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("AllReduce preprocessing done. Running Reducer code."));
        }
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        ReduceFunction<T> stub = this.taskContext.getStub();
        MutableObjectIterator<T> input = this.input;
        TypeSerializer<T> serializer = this.serializer;
        CountingCollector<T> collector = new CountingCollector<T>(this.taskContext.getOutputCollector(), numRecordsOut);
        Object val1 = input.next();
        if (val1 == null) {
            return;
        }
        numRecordsIn.inc();
        if (this.objectReuseEnabled) {
            Object val2 = serializer.createInstance();
            Object value = val1;
            while (this.running && (val2 = input.next(val2)) != null) {
                numRecordsIn.inc();
                if ((value = stub.reduce(value, val2)) != val2) continue;
                Object tmp = val1;
                val1 = val2;
                val2 = tmp;
            }
            collector.collect(value);
        } else {
            Object val2;
            while (this.running && (val2 = input.next()) != null) {
                numRecordsIn.inc();
                val1 = stub.reduce(val1, val2);
            }
            collector.collect(val1);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

