/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class SlotProfile {
    private static final SlotProfile NO_REQUIREMENTS = SlotProfile.noLocality(ResourceProfile.UNKNOWN);
    private final ResourceProfile taskResourceProfile;
    private final ResourceProfile physicalSlotResourceProfile;
    private final Collection<TaskManagerLocation> preferredLocations;
    private final Collection<AllocationID> preferredAllocations;
    private final Set<AllocationID> previousExecutionGraphAllocations;

    private SlotProfile(ResourceProfile taskResourceProfile, ResourceProfile physicalSlotResourceProfile, Collection<TaskManagerLocation> preferredLocations, Collection<AllocationID> preferredAllocations, Set<AllocationID> previousExecutionGraphAllocations) {
        this.taskResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)taskResourceProfile);
        this.physicalSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)physicalSlotResourceProfile);
        this.preferredLocations = (Collection)Preconditions.checkNotNull(preferredLocations);
        this.preferredAllocations = (Collection)Preconditions.checkNotNull(preferredAllocations);
        this.previousExecutionGraphAllocations = (Set)Preconditions.checkNotNull(previousExecutionGraphAllocations);
    }

    public ResourceProfile getTaskResourceProfile() {
        return this.taskResourceProfile;
    }

    public ResourceProfile getPhysicalSlotResourceProfile() {
        return this.physicalSlotResourceProfile;
    }

    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    public Collection<AllocationID> getPreferredAllocations() {
        return this.preferredAllocations;
    }

    public Set<AllocationID> getPreviousExecutionGraphAllocations() {
        return this.previousExecutionGraphAllocations;
    }

    @VisibleForTesting
    public static SlotProfile noRequirements() {
        return NO_REQUIREMENTS;
    }

    @VisibleForTesting
    public static SlotProfile noLocality(ResourceProfile resourceProfile) {
        return SlotProfile.preferredLocality(resourceProfile, Collections.emptyList());
    }

    @VisibleForTesting
    public static SlotProfile preferredLocality(ResourceProfile resourceProfile, Collection<TaskManagerLocation> preferredLocations) {
        return SlotProfile.priorAllocation(resourceProfile, resourceProfile, preferredLocations, Collections.emptyList(), Collections.emptySet());
    }

    public static SlotProfile priorAllocation(ResourceProfile taskResourceProfile, ResourceProfile physicalSlotResourceProfile, Collection<TaskManagerLocation> preferredLocations, Collection<AllocationID> priorAllocations, Set<AllocationID> previousExecutionGraphAllocations) {
        return new SlotProfile(taskResourceProfile, physicalSlotResourceProfile, preferredLocations, priorAllocations, previousExecutionGraphAllocations);
    }
}

