/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class LogAggregationFileController {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationFileController.class);
    protected static final FsPermission TLDIR_PERMISSIONS = FsPermission.createImmutable((short)1023);
    protected static final FsPermission APP_DIR_PERMISSIONS = FsPermission.createImmutable((short)504);
    protected static final FsPermission APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
    private static final String NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = "yarn.nodemanager.log-aggregation.num-log-files-per-app";
    private static final int DEFAULT_NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = 30;
    public static final String LOG_AGGREGATION_FS_SUPPORT_APPEND = "yarn.log-aggregation.fs-support-append";
    protected Configuration conf;
    protected Path remoteRootLogDir;
    protected String remoteRootLogDirSuffix;
    protected int retentionSize;
    protected String fileControllerName;

    public void initialize(Configuration conf, String controllerName) {
        this.conf = conf;
        int configuredRentionSize = conf.getInt(NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP, 30);
        this.retentionSize = configuredRentionSize <= 0 ? 30 : configuredRentionSize;
        this.fileControllerName = controllerName;
        this.initInternal(conf);
    }

    protected abstract void initInternal(Configuration var1);

    public Path getRemoteRootLogDir() {
        return this.remoteRootLogDir;
    }

    public String getRemoteRootLogDirSuffix() {
        return this.remoteRootLogDirSuffix;
    }

    public abstract void initializeWriter(LogAggregationFileControllerContext var1) throws IOException;

    public abstract void closeWriter();

    public abstract void write(AggregatedLogFormat.LogKey var1, AggregatedLogFormat.LogValue var2) throws IOException;

    public abstract void postWrite(LogAggregationFileControllerContext var1) throws Exception;

    protected void closePrintStream(OutputStream out) {
        if (out != System.out) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out});
        }
    }

    public abstract boolean readAggregatedLogs(ContainerLogsRequest var1, OutputStream var2) throws IOException;

    public abstract List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest var1) throws IOException;

    public abstract void renderAggregatedLogsBlock(HtmlBlock.Block var1, View.ViewContext var2);

    public abstract String getApplicationOwner(Path var1) throws IOException;

    public abstract Map<ApplicationAccessType, String> getApplicationAcls(Path var1) throws IOException;

    public void verifyAndCreateRemoteLogDir() {
        boolean logPermError = true;
        FileSystem remoteFS = null;
        try {
            remoteFS = this.getFileSystem(this.conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Unable to get Remote FileSystem instance", (Throwable)e);
        }
        boolean remoteExists = true;
        Path remoteRootLogDir = this.getRemoteRootLogDir();
        try {
            FsPermission perms = remoteFS.getFileStatus(remoteRootLogDir).getPermission();
            if (!perms.equals((Object)TLDIR_PERMISSIONS) && logPermError) {
                LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] already exist, but with incorrect permissions. " + "Expected: [" + TLDIR_PERMISSIONS + "], Found: [" + perms + "]." + " The cluster may have problems with multiple users.");
                logPermError = false;
            } else {
                logPermError = true;
            }
        }
        catch (FileNotFoundException e) {
            remoteExists = false;
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to check permissions for dir [" + remoteRootLogDir + "]", (Throwable)e);
        }
        if (!remoteExists) {
            LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] does not exist. Attempting to create it.");
            try {
                Path qualified = remoteRootLogDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                remoteFS.mkdirs(qualified, new FsPermission(TLDIR_PERMISSIONS));
                remoteFS.setPermission(qualified, new FsPermission(TLDIR_PERMISSIONS));
                UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                String primaryGroupName = null;
                try {
                    primaryGroupName = loginUser.getPrimaryGroupName();
                }
                catch (IOException e) {
                    LOG.warn("No primary group found. The remote root log directory will be created with the HDFS superuser being its group owner. JobHistoryServer may be unable to read the directory.");
                }
                if (primaryGroupName != null) {
                    remoteFS.setOwner(qualified, loginUser.getShortUserName(), primaryGroupName);
                }
            }
            catch (IOException e) {
                throw new YarnRuntimeException("Failed to create remoteLogDir [" + remoteRootLogDir + "]", (Throwable)e);
            }
        }
    }

    public void createAppDir(final String user, final ApplicationId appId, UserGroupInformation userUgi) {
        final Path remoteRootLogDir = this.getRemoteRootLogDir();
        final String remoteRootLogDirSuffix = this.getRemoteRootLogDirSuffix();
        try {
            userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        FileSystem remoteFS = LogAggregationFileController.this.getFileSystem(LogAggregationFileController.this.conf);
                        Path appDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, remoteRootLogDirSuffix);
                        appDir = appDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                        if (!LogAggregationFileController.this.checkExists(remoteFS, appDir, APP_DIR_PERMISSIONS)) {
                            Path suffixDir = LogAggregationUtils.getRemoteLogSuffixedDir(remoteRootLogDir, user, remoteRootLogDirSuffix);
                            if (!LogAggregationFileController.this.checkExists(remoteFS, suffixDir = suffixDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()), APP_DIR_PERMISSIONS)) {
                                Path userDir = LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user);
                                if (!LogAggregationFileController.this.checkExists(remoteFS, userDir = userDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()), APP_DIR_PERMISSIONS)) {
                                    LogAggregationFileController.this.createDir(remoteFS, userDir, APP_DIR_PERMISSIONS);
                                }
                                LogAggregationFileController.this.createDir(remoteFS, suffixDir, APP_DIR_PERMISSIONS);
                            }
                            LogAggregationFileController.this.createDir(remoteFS, appDir, APP_DIR_PERMISSIONS);
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Failed to setup application log directory for " + appId, (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return this.getRemoteRootLogDir().getFileSystem(conf);
    }

    protected void createDir(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        FsPermission dirPerm = new FsPermission(fsPerm);
        fs.mkdirs(path, dirPerm);
        FsPermission umask = FsPermission.getUMask((Configuration)fs.getConf());
        if (!dirPerm.equals((Object)dirPerm.applyUMask(umask))) {
            fs.setPermission(path, new FsPermission(fsPerm));
        }
    }

    protected boolean checkExists(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        boolean exists = true;
        try {
            FileStatus appDirStatus = fs.getFileStatus(path);
            if (!APP_DIR_PERMISSIONS.equals((Object)appDirStatus.getPermission())) {
                fs.setPermission(path, APP_DIR_PERMISSIONS);
            }
        }
        catch (FileNotFoundException fnfe) {
            exists = false;
        }
        return exists;
    }

    public Path getRemoteNodeLogFileForApp(ApplicationId appId, String user, NodeId nodeId) {
        return LogAggregationUtils.getRemoteNodeLogFileForApp(this.getRemoteRootLogDir(), appId, user, nodeId, this.getRemoteRootLogDirSuffix());
    }

    public Path getRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        return LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
    }

    protected void cleanOldLogs(Path remoteNodeLogFileForApp, final NodeId nodeId, UserGroupInformation userUgi) {
        try {
            final FileSystem remoteFS = remoteNodeLogFileForApp.getFileSystem(this.conf);
            Path appDir = remoteNodeLogFileForApp.getParent().makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
            HashSet status = new HashSet(Arrays.asList(remoteFS.listStatus(appDir)));
            Iterable mask = Iterables.filter(status, (Predicate)new Predicate<FileStatus>(){

                public boolean apply(FileStatus next) {
                    return next.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) && !next.getPath().getName().endsWith(".tmp");
                }
            });
            status = Sets.newHashSet((Iterable)mask);
            if (status.size() >= this.retentionSize) {
                ArrayList statusList = new ArrayList(status);
                Collections.sort(statusList, new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus s1, FileStatus s2) {
                        return s1.getModificationTime() < s2.getModificationTime() ? -1 : (s1.getModificationTime() > s2.getModificationTime() ? 1 : 0);
                    }
                });
                for (int i = 0; i <= statusList.size() - this.retentionSize; ++i) {
                    final FileStatus remove = (FileStatus)statusList.get(i);
                    try {
                        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                remoteFS.delete(remove.getPath(), false);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete " + remove.getPath(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to clean old logs", (Throwable)e);
        }
    }

    protected String aggregatedLogSuffix(String fileName) {
        StringBuilder sb = new StringBuilder();
        String endOfFile = "End of LogType:" + fileName;
        sb.append("\n" + endOfFile + "\n");
        sb.append(StringUtils.repeat((String)"*", (int)(endOfFile.length() + 50)) + "\n\n");
        return sb.toString();
    }
}

