/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.proxy.ChildFirstClassLoader;
import org.apache.streampark.flink.proxy.ClassLoaderObjectInputStream;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class FlinkShimsProxy$
implements org.apache.streampark.common.util.Logger {
    public static final FlinkShimsProxy$ MODULE$;
    public final Pattern org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN;
    public final Pattern org$apache$streampark$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN;
    private final Map<String, ClassLoader> SHIMS_CLASS_LOADER_CACHE;
    private final Map<String, ClassLoader> VERIFY_SQL_CLASS_LOADER_CACHE;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new FlinkShimsProxy$();
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return Logger.class.logger((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.class.initializeLogIfNecessary((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    public Pattern org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(String flinkLargeVersion) {
        return Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"flink-(.*)-", "(.*).jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkLargeVersion})), 34);
    }

    private Pattern getStreamParkLibPattern(String scalaVersion) {
        return Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streampark-(.*)_", "-(.*).jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scalaVersion})), 34);
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function1<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;
            private final ClassLoader shimsClassLoader$1;

            public final T apply() {
                return (T)this.func$1.apply((Object)this.shimsClassLoader$1);
            }
            {
                this.func$1 = func$1;
                this.shimsClassLoader$1 = shimsClassLoader$1;
            }
        });
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function func$2;
            private final ClassLoader shimsClassLoader$2;

            public final T apply() {
                return (T)this.func$2.apply(this.shimsClassLoader$2);
            }
            {
                this.func$2 = func$2;
                this.shimsClassLoader$2 = shimsClassLoader$2;
            }
        });
    }

    public ClassLoader getVerifySqlLibClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add verify sql lib,flink version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkVersion$2}));
            }
            {
                this.flinkVersion$2 = flinkVersion$2;
            }
        });
        return (ClassLoader)this.VERIFY_SQL_CLASS_LOADER_CACHE.getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkVersion.fullVersion()})), (Function0)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$2;

            public final ChildFirstClassLoader apply() {
                Serializable getFlinkTable = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$1) {
                        return x$1.getName().startsWith("flink-table");
                    }
                };
                List<URL> libTableURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$2.flinkHome(), "lib", (Function1<File, Object>)getFlinkTable);
                List<URL> optTableURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$2.flinkHome(), "opt", (Function1<File, Object>)getFlinkTable);
                ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)libTableURL.$plus$plus(optTableURL, List$.MODULE$.canBuildFrom()));
                FlinkShimsProxy$.MODULE$.addShimsUrls(this.flinkVersion$2, (Function1<File, BoxedUnit>)new Serializable(this, shimsUrls){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer shimsUrls$1;

                    public final void apply(File file) {
                        if (file != null && file.getName().startsWith("streampark-flink-shims")) {
                            this.shimsUrls$1.$plus$eq((Object)file.toURI().toURL());
                        }
                    }
                    {
                        this.shimsUrls$1 = shimsUrls$1;
                    }
                });
                return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(this.flinkVersion$2.majorVersion()));
            }
            {
                this.flinkVersion$2 = flinkVersion$2;
            }
        });
    }

    public void addShimsUrls(FlinkVersion flinkVersion, Function1<File, BoxedUnit> addShimUrl) {
        String appHome = System.getProperty(ConfigConst$.MODULE$.KEY_APP_HOME());
        Predef$.MODULE$.require(appHome != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return String.format("%s is not found on System env.", ConfigConst$.MODULE$.KEY_APP_HOME());
            }
        });
        File libPath = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/lib"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appHome})));
        Predef$.MODULE$.require(libPath.exists());
        String majorVersion = flinkVersion.majorVersion();
        String scalaVersion = flinkVersion.scalaVersion();
        Pattern streamParkMatcher = this.getStreamParkLibPattern(scalaVersion);
        Predef$.MODULE$.refArrayOps((Object[])libPath.listFiles()).foreach((Function1)new Serializable(addShimUrl, majorVersion, scalaVersion, streamParkMatcher){
            public static final long serialVersionUID = 0L;
            private final Function1 addShimUrl$1;
            private final String majorVersion$1;
            private final String scalaVersion$1;
            private final Pattern streamParkMatcher$1;

            public final void apply(File jar) {
                try {
                    Matcher shimsMatcher = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN.matcher(jar.getName());
                    if (shimsMatcher.matches()) {
                        String string = this.majorVersion$1;
                        String string2 = shimsMatcher.group(1);
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = this.scalaVersion$1;
                            String string4 = shimsMatcher.group(2);
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                this.addShimUrl$1.apply((Object)jar);
                            }
                        }
                    } else {
                        if (FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN.matcher(jar.getName()).matches()) {
                            this.addShimUrl$1.apply((Object)jar);
                            FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jar){
                                public static final long serialVersionUID = 0L;
                                private final File jar$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include jar lib: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jar$1.getName()}));
                                }
                                {
                                    this.jar$1 = jar$1;
                                }
                            });
                        }
                        if (this.streamParkMatcher$1.matcher(jar.getName()).matches()) {
                            this.addShimUrl$1.apply((Object)jar);
                            FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jar){
                                public static final long serialVersionUID = 0L;
                                private final File jar$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include streampark lib: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jar$1.getName()}));
                                }
                                {
                                    this.jar$1 = jar$1;
                                }
                            });
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            {
                this.addShimUrl$1 = addShimUrl$1;
                this.majorVersion$1 = majorVersion$1;
                this.scalaVersion$1 = scalaVersion$1;
                this.streamParkMatcher$1 = streamParkMatcher$1;
            }
        });
    }

    public <T> T proxyVerifySql(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getVerifySqlLibClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function func$3;
            private final ClassLoader shimsClassLoader$3;

            public final T apply() {
                return (T)this.func$3.apply(this.shimsClassLoader$3);
            }
            {
                this.func$3 = func$3;
                this.shimsClassLoader$3 = shimsClassLoader$3;
            }
        });
    }

    private ClassLoader getFlinkShimsClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add flink shims urls classloader,flink version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkVersion$1}));
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
            }
        });
        return (ClassLoader)this.SHIMS_CLASS_LOADER_CACHE.getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkVersion.fullVersion()})), (Function0)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;

            public final ChildFirstClassLoader apply() {
                List<URL> libURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$1.flinkHome(), "lib", (Function1<File, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$2) {
                        return !x$2.getName().startsWith("log4j");
                    }
                });
                ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply(libURL);
                FlinkShimsProxy$.MODULE$.addShimsUrls(this.flinkVersion$1, (Function1<File, BoxedUnit>)new Serializable(this, shimsUrls){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer shimsUrls$2;

                    public final void apply(File file) {
                        if (file != null) {
                            this.shimsUrls$2.$plus$eq((Object)file.toURI().toURL());
                        }
                    }
                    {
                        this.shimsUrls$2 = shimsUrls$2;
                    }
                });
                return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(this.flinkVersion$1.majorVersion()));
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
            }
        });
    }

    public List<URL> org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(String flinkHome, String childDir, Function1<File, Object> filterFun) {
        File file = new File(flinkHome, childDir);
        Predef$.MODULE$.require(file.isDirectory(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLINK_HOME ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).filter(filterFun)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(File x$3) {
                return x$3.toURI().toURL();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)))).toList();
    }

    public <T> T getObject(ClassLoader loader, Object obj) throws Exception {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Object result = Utils$.MODULE$.tryWithResource((AutoCloseable)new ObjectOutputStream(arrayOutputStream), (Function1)new Serializable(loader, obj, arrayOutputStream){
            public static final long serialVersionUID = 0L;
            private final ClassLoader loader$1;
            private final Object obj$1;
            private final ByteArrayOutputStream arrayOutputStream$1;

            public final Object apply(ObjectOutputStream objectOutputStream) {
                objectOutputStream.writeObject(this.obj$1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.arrayOutputStream$1.toByteArray());
                return Utils$.MODULE$.tryWithResource((AutoCloseable)new ClassLoaderObjectInputStream(this.loader$1, byteArrayInputStream), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ClassLoaderObjectInputStream x$4) {
                        return x$4.readObject();
                    }
                }, (Function1)Predef$.MODULE$.$conforms());
            }
            {
                this.loader$1 = loader$1;
                this.obj$1 = obj$1;
                this.arrayOutputStream$1 = arrayOutputStream$1;
            }
        }, (Function1)Predef$.MODULE$.$conforms());
        return (T)result;
    }

    private FlinkShimsProxy$() {
        MODULE$ = this;
        Logger.class.$init$((org.apache.streampark.common.util.Logger)this);
        this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN = Pattern.compile("(json4s|jackson)(.*).jar", 34);
        this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$SHIMS_PATTERN = Pattern.compile("streampark-flink-shims_flink-(1.12|1.13|1.14|1.15|1.16)_(2.11|2.12)-(.*).jar", 34);
        this.SHIMS_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.VERIFY_SQL_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

